/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.oauth;

import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.impl.oauth.AccessTokenData;
import fr.obeo.perseus.client.util.PerseusProperties;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class OAuthCredentials
implements HttpRequestInterceptor,
HttpResponseInterceptor {
    private final AccessTokenData tokenData;
    private Instant expiresAt;

    public OAuthCredentials(AccessTokenData tokenData) {
        this(tokenData, Clock.systemUTC());
    }

    public OAuthCredentials(AccessTokenData tokenData, Clock clock) {
        this.tokenData = Objects.requireNonNull(tokenData);
        Objects.requireNonNull(tokenData.getAccessToken());
        Objects.requireNonNull(tokenData.getTokenType());
        this.expiresAt = tokenData.getExpiresIn() != null ? clock.instant().plusSeconds(tokenData.getExpiresIn().intValue()) : null;
        if (PerseusProperties.isDebug()) {
            PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", String.format("New OAuth Credentials obtained: token data: %s, expires at: %s ", tokenData, this.expiresAt)));
        }
    }

    public final boolean isExpired(Clock clock) {
        return this.expiresAt != null && clock.instant().isAfter(this.expiresAt);
    }

    public final boolean expiresInLessThan(TemporalAmount duration, Clock clock) {
        return this.expiresAt != null && clock.instant().plus(duration).isAfter(this.expiresAt);
    }

    public final AccessTokenData getAccessTokenData() {
        return this.tokenData;
    }

    public final Instant getExpiresAt() {
        return this.expiresAt;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if ("bearer".equalsIgnoreCase(this.tokenData.getTokenType())) {
            if (PerseusProperties.getOAuth2UseIDTokenForAccess() && this.tokenData.getAdditionalProperties().containsKey("id_token")) {
                Object idToken = this.tokenData.getAdditionalProperties().get("id_token");
                request.addHeader("Authorization", "Bearer " + idToken);
                if (PerseusProperties.isDebug()) {
                    PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", "Using id_token."));
                }
            } else {
                request.addHeader("Authorization", "Bearer " + this.tokenData.getAccessToken());
                if (PerseusProperties.isDebug()) {
                    PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", "Using accessToken."));
                }
            }
        } else {
            PerseusClientPlugin.getPlugin().logError(String.format("Unsupported OAuth-2.0 token type '%s', communication with the Publication server will not work.", this.tokenData.getTokenType()), null);
        }
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (response.getStatusLine().getStatusCode() == 401) {
            if (PerseusProperties.isDebug()) {
                PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", "Publication server returned 401, access_token is now invalidated."));
            }
            this.expiresAt = Instant.now();
        }
    }
}

