/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.impl.oauth.AccessTokenData;
import fr.obeo.perseus.client.impl.oauth.AccessTokenError;
import fr.obeo.perseus.client.impl.oauth.IAccessTokenResponse;
import fr.obeo.perseus.client.util.PerseusHttpSupport;
import java.io.IOException;
import java.util.Optional;
import org.apache.http.Header;

public class TokenResponse
implements IAccessTokenResponse {
    private final int status;
    private final String body;
    private final Header[] headers;
    private ObjectMapper mapper;

    public TokenResponse(int status, String body, Header[] headers) {
        this.status = status;
        this.body = body;
        this.headers = headers;
    }

    @Override
    public final int getStatus() {
        return this.status;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public final Header[] getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isSuccess() {
        return this.status / 100 == 2;
    }

    @Override
    public Optional<AccessTokenError> getError() {
        if (!this.isSuccess()) {
            try {
                return Optional.of((AccessTokenError)this.getMapper().readerFor(AccessTokenError.class).readValue(this.body));
            }
            catch (IOException | RuntimeException e) {
                PerseusClientPlugin.getPlugin().logError("Could not read error message", e);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<AccessTokenData> getAccessTokenData() {
        if (this.isSuccess()) {
            try {
                return Optional.of((AccessTokenData)this.getMapper().readerFor(AccessTokenData.class).readValue(this.body));
            }
            catch (IOException | RuntimeException e) {
                PerseusClientPlugin.getPlugin().logError("Could not read error message", e);
            }
        }
        return Optional.empty();
    }

    private ObjectMapper getMapper() {
        return Optional.ofNullable(this.mapper).orElseGet(PerseusHttpSupport::createObjectMapper);
    }
}

