/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.runnables;

import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.impl.graphql.GQLOslcArtifactDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public final class MutationRefreshOslcArtifactsRunnable
implements IRunnableWithProgress {
    private final IPerseusServerConfig serverConfig;
    private final Collection<String> artifactUrls;
    private final String projectId;
    private final Optional<String> optConfigurationUri;
    private List<GQLOslcArtifactDescriptor> artifactDescriptors;

    public MutationRefreshOslcArtifactsRunnable(IPerseusServerConfig serverConfig, Collection<String> artifactUrls, String projectId, Optional<String> optConfigurationUri) {
        this.serverConfig = Objects.requireNonNull(serverConfig);
        this.artifactUrls = Objects.requireNonNull(artifactUrls);
        this.projectId = Objects.requireNonNull(projectId);
        this.optConfigurationUri = Objects.requireNonNull(optConfigurationUri);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.artifactUrls.size());
        try {
            this.artifactDescriptors = PerseusClientPlugin.getPlugin().getOslcDataFetcher().refreshOslcArtifactDescriptors(this.serverConfig, this.projectId, this.artifactUrls, this.optConfigurationUri, (IProgressMonitor)progress.split(1));
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        catch (PerseusServerException | IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    public List<GQLOslcArtifactDescriptor> getArtifactDescriptors() {
        return this.artifactDescriptors;
    }
}

