/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.runnables;

import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IArtifactID;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.impl.graphql.GQLOslcArtifactDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public final class QueryOslcArtifactDescriptorsRunnable
implements IRunnableWithProgress {
    private final IPerseusServerConfig serverConfig;
    private final String projectId;
    private final Collection<IArtifactID> artifactIDs;
    private final Optional<String> optConfigUri;
    private List<GQLOslcArtifactDescriptor> artifactDescriptors;

    public QueryOslcArtifactDescriptorsRunnable(IPerseusServerConfig serverConfig, String projectId, Optional<String> optConfigUri, Collection<IArtifactID> artifactIDs) {
        this.serverConfig = Objects.requireNonNull(serverConfig);
        this.projectId = Objects.requireNonNull(projectId);
        this.optConfigUri = Objects.requireNonNull(optConfigUri);
        this.artifactIDs = Objects.requireNonNull(artifactIDs);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.artifactIDs.size());
        this.artifactDescriptors = new ArrayList<GQLOslcArtifactDescriptor>(this.artifactIDs.size());
        try {
            for (IArtifactID artifactID : this.artifactIDs) {
                GQLOslcArtifactDescriptor artifact = PerseusClientPlugin.getPlugin().getOslcDataFetcher().getOslcArtifactDescriptor(this.serverConfig, this.projectId, artifactID, this.optConfigUri, (IProgressMonitor)progress.split(1));
                this.artifactDescriptors.add(artifact);
            }
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException();
        }
        catch (PerseusServerException | IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    public List<GQLOslcArtifactDescriptor> getArtifactDescriptors() {
        return this.artifactDescriptors;
    }
}

