/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.traceability;

import fr.obeo.dsl.traceability.LinkSnapshot;
import fr.obeo.dsl.traceability.LinksByModelObjectId;
import fr.obeo.dsl.traceability.TraceabilityFactory;
import fr.obeo.dsl.traceability.TraceabilitySnapshot;
import fr.obeo.dsl.traceability.UriPrefix;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryStrategy;
import fr.obeo.dsl.traceability.api.ISnapshotComparison;
import fr.obeo.dsl.traceability.api.ISnapshotDiffAction;
import fr.obeo.dsl.traceability.api.ISnapshotDifference;
import fr.obeo.dsl.traceability.api.TraceabilityLinkDifferenceKind;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.impl.graphql.GQLOslcArtifactDescriptor;
import fr.obeo.perseus.client.impl.graphql.GQLOslcLinkDescriptor;
import fr.obeo.perseus.client.impl.graphql.GQLOslcLinkDescriptorsByFriend;
import fr.obeo.perseus.client.impl.traceability.AcceptedSnapshotDiffAction;
import fr.obeo.perseus.client.impl.traceability.ArtifactRepositoryChangeSet;
import fr.obeo.perseus.client.impl.traceability.IndexedFriendLinkDescriptors;
import fr.obeo.perseus.client.impl.traceability.RejectedSnapshotDiffAction;
import fr.obeo.perseus.client.impl.traceability.SessionTraceabilityStrategy;
import fr.obeo.perseus.client.impl.traceability.SnapshotDiffAction;
import fr.obeo.perseus.client.util.NamespaceHelper;
import fr.obeo.perseus.client.util.URIRef;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public class ArtifactRepositoryChangeSetFactory {
    private final IArtifactRepositoryStrategy repositoryStrategy;
    private final Function<String, Optional<EObject>> findSemanticObjectById;

    public ArtifactRepositoryChangeSetFactory(IArtifactRepositoryStrategy repositoryStrategy, Function<String, Optional<EObject>> findSemanticObjectById) {
        this.repositoryStrategy = Objects.requireNonNull(repositoryStrategy);
        this.findSemanticObjectById = Objects.requireNonNull(findSemanticObjectById);
    }

    public ArtifactRepositoryChangeSet create(GQLOslcLinkDescriptorsByFriend linkDescriptorsByFriend) throws CoreException {
        List<ISnapshotDiffAction> diffActions;
        TraceabilitySnapshot snapshot = this.buildSnapshot(linkDescriptorsByFriend);
        IndexedFriendLinkDescriptors indexedLinkDescriptors = new IndexedFriendLinkDescriptors(linkDescriptorsByFriend);
        ISnapshotComparison comparison = this.repositoryStrategy.compareWithLatestSnapshot(snapshot);
        if (comparison.getSize() > 0) {
            diffActions = new ArrayList(comparison.getSize());
            comparison.getDifferences().forEach(theDiff -> {
                GQLOslcArtifactDescriptor artifactDescriptor = indexedLinkDescriptors.findArtifactDescriptor(theDiff.getLinkDescriptor().getArtifactURL()).orElseGet(() -> {
                    if (theDiff.getKind() != TraceabilityLinkDifferenceKind.DELETE && PerseusClientPlugin.getPlugin() != null) {
                        PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client", String.format("Artifact '%s' has not been provided by the Publication server.", theDiff.getLinkDescriptor().getArtifactURL())));
                    }
                    return this.repositoryStrategy.findArtifact(theDiff.getLinkDescriptor().getArtifactURL()).map(GQLOslcArtifactDescriptor::createFromArtifact).orElse(null);
                });
                if (artifactDescriptor != null) {
                    SnapshotDiffAction action = this.findSemanticObjectById.apply(theDiff.getLinkDescriptor().getModelObjectId()).isPresent() ? new SnapshotDiffAction((ISnapshotDifference)theDiff, artifactDescriptor) : (theDiff.getKind() == TraceabilityLinkDifferenceKind.ADD ? new RejectedSnapshotDiffAction((ISnapshotDifference)theDiff, artifactDescriptor) : new AcceptedSnapshotDiffAction((ISnapshotDifference)theDiff, artifactDescriptor));
                    diffActions.add(action);
                } else if (PerseusClientPlugin.getPlugin() != null) {
                    PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client", String.format("A difference %s about a link '%s' to an unknown artifact '%s' has been ignored.", theDiff.getKind(), theDiff.getLinkDescriptor().getTypeDescriptor().getURI(), theDiff.getLinkDescriptor().getArtifactURL())));
                }
            });
        } else {
            diffActions = Collections.emptyList();
        }
        ArtifactRepositoryChangeSet result = new ArtifactRepositoryChangeSet(this.repositoryStrategy.getArtifactRepositoryURL(), snapshot, diffActions);
        return result;
    }

    private TraceabilitySnapshot buildSnapshot(GQLOslcLinkDescriptorsByFriend linkDescriptors) {
        Map preferredPrefixes = this.repositoryStrategy.getTraceabilityStrategy().findTraceability().map(traceability -> traceability.getDomains().stream().filter(SessionTraceabilityStrategy::isValid).collect(Collectors.toMap(dom -> dom.getPrefix(), dom -> dom.getUri()))).orElseGet(Collections::emptyMap);
        NamespaceHelper nsHelper = new NamespaceHelper(preferredPrefixes);
        TraceabilitySnapshot newSnapshot = TraceabilityFactory.eINSTANCE.createTraceabilitySnapshot();
        newSnapshot.setTimestamp(Instant.now());
        Map<String, LinksByModelObjectId> map = newSnapshot.getLinksByModelObjectId().stream().collect(Collectors.toMap(l -> l.getKey(), l -> l));
        for (GQLOslcLinkDescriptor linkDescriptor : linkDescriptors.getLinkDescriptors()) {
            LinkSnapshot linkSnapshot = TraceabilityFactory.eINSTANCE.createLinkSnapshot();
            linkSnapshot.setArtifactURL(linkDescriptor.getArtifactUrl());
            URIRef uriRef = new URIRef(URI.create(linkDescriptor.getType().getUri()));
            String prefixedName = nsHelper.asPrefixedName(uriRef.getPrefix(), uriRef.getLocalName());
            linkSnapshot.setTypeName(prefixedName);
            LinksByModelObjectId links = map.computeIfAbsent(linkDescriptor.getObjectId(), oid -> {
                LinksByModelObjectId newLinks = TraceabilityFactory.eINSTANCE.createLinksByModelObjectId();
                newLinks.setKey(oid);
                return newLinks;
            });
            if (!links.getValue().stream().anyMatch(ls -> this.isEqual((LinkSnapshot)ls, linkSnapshot))) {
                links.getValue().add((Object)linkSnapshot);
                continue;
            }
            if (PerseusClientPlugin.getPlugin() == null) continue;
            PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client", String.format("The publication server sent a duplicated link '%s' from object with ID '%s' to artifact '%s' which will be safely ignored.\nHowever, the server should not send duplicated links.", linkDescriptor.getType().getUri(), linkDescriptor.getObjectId(), linkDescriptor.getArtifactUrl())));
        }
        newSnapshot.getLinksByModelObjectId().addAll(map.values());
        nsHelper.getKnownURIsByPrefix().forEach((prefix, uri) -> {
            UriPrefix uriPrefix = TraceabilityFactory.eINSTANCE.createUriPrefix();
            uriPrefix.setKey(prefix);
            uriPrefix.setValue(uri);
            newSnapshot.getUriPrefixes().add((Object)uriPrefix);
        });
        return newSnapshot;
    }

    private boolean isEqual(LinkSnapshot ls, LinkSnapshot linkSnapshot) {
        return ls.getArtifactURL().equals(linkSnapshot.getArtifactURL()) && ls.getDirection().equals((Object)linkSnapshot.getDirection()) && ls.getTypeName().equals(linkSnapshot.getTypeName());
    }
}

