/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.traceability;

import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.impl.graphql.GQLOslcArtifactDescriptor;
import fr.obeo.perseus.client.impl.graphql.GQLOslcLinkDescriptor;
import fr.obeo.perseus.client.impl.graphql.GQLOslcLinkDescriptorsByFriend;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class IndexedFriendLinkDescriptors {
    private final GQLOslcLinkDescriptorsByFriend linkDescriptorsByFriend;
    private final Map<String, GQLOslcArtifactDescriptor> artifactDescriptorsByUrl;

    public IndexedFriendLinkDescriptors(GQLOslcLinkDescriptorsByFriend linkDescriptorsByFriend) {
        this.linkDescriptorsByFriend = Objects.requireNonNull(linkDescriptorsByFriend);
        Set artifactURLs = Optional.ofNullable(linkDescriptorsByFriend.getLinkDescriptors()).orElseGet(Collections::emptyList).stream().map(GQLOslcLinkDescriptor::getArtifactUrl).collect(Collectors.toSet());
        this.artifactDescriptorsByUrl = Optional.ofNullable(linkDescriptorsByFriend.getArtifactDescriptors()).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(GQLOslcArtifactDescriptor::getArtifactUrl, ad -> ad, (ad1, ad2) -> ad1));
        if (!this.artifactDescriptorsByUrl.keySet().containsAll(artifactURLs) && PerseusClientPlugin.getPlugin() != null) {
            PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client", "The Publication server has sent incomplete data: Some artifact descriptors are missing for some links."));
        }
    }

    public Optional<GQLOslcArtifactDescriptor> findArtifactDescriptor(String artifactUrl) {
        return Optional.ofNullable(this.artifactDescriptorsByUrl.get(artifactUrl));
    }

    public GQLOslcLinkDescriptorsByFriend getLinkDescriptorsByFriend() {
        return this.linkDescriptorsByFriend;
    }
}

