/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.traceability;

import fr.obeo.dsl.traceability.api.ILinkDescriptor;
import fr.obeo.dsl.traceability.api.ITypeDescriptor;
import fr.obeo.perseus.client.impl.traceability.TypeDescriptor;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public final class LinkDescriptor
implements ILinkDescriptor {
    private final String artifactURL;
    private final ITypeDescriptor linkTypeDescriptor;
    private final String modelObjectId;
    private final boolean incoming;

    private LinkDescriptor(String artifactURL, ITypeDescriptor linkTypeDescriptor, String modelObjectId, boolean incoming) {
        this.artifactURL = Objects.requireNonNull(artifactURL);
        this.linkTypeDescriptor = Objects.requireNonNull(linkTypeDescriptor);
        this.modelObjectId = Objects.requireNonNull(modelObjectId);
        this.incoming = incoming;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getArtifactURL() {
        return this.artifactURL;
    }

    public ITypeDescriptor getTypeDescriptor() {
        return this.linkTypeDescriptor;
    }

    public String getModelObjectId() {
        return this.modelObjectId;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public byte[] getHash() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update("modelElementURI:".getBytes());
            md.update(this.modelObjectId.getBytes());
            md.update((byte)0);
            md.update("linkTypeURI:".getBytes());
            md.update(this.linkTypeDescriptor.getURI().getBytes());
            md.update((byte)0);
            md.update("artifactURL:".getBytes());
            md.update(this.artifactURL.toString().getBytes());
            md.update((byte)0);
            md.update(this.incoming ? (byte)1 : 0);
            byte[] digest = md.digest();
            return digest;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException();
        }
    }

    /* synthetic */ LinkDescriptor(String string, ITypeDescriptor iTypeDescriptor, String string2, boolean bl, LinkDescriptor linkDescriptor) {
        this(string, iTypeDescriptor, string2, bl);
    }

    public static class Builder {
        private String artifact;
        private ITypeDescriptor linkTypeDescriptor;
        private String modelObjectId;
        private boolean incoming;

        public Builder artifact(String uri) {
            this.artifact = uri;
            return this;
        }

        public Builder linkType(String nsURI, String name) {
            this.linkTypeDescriptor = new TypeDescriptor(nsURI, name);
            return this;
        }

        public Builder modelObjectId(String id) {
            this.modelObjectId = id;
            return this;
        }

        public Builder incoming(boolean value) {
            this.incoming = value;
            return this;
        }

        public LinkDescriptor build() {
            return new LinkDescriptor(this.artifact, this.linkTypeDescriptor, this.modelObjectId, this.incoming, null);
        }
    }
}

