/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.traceability;

import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.impl.SessionModelDataProvider;
import fr.obeo.perseus.client.impl.SessionModelTranslationScope;
import fr.obeo.perseus.client.impl.traceability.SessionTraceabilityStrategy;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class PerseusSessionManagerListener
implements SessionManagerListener {
    private final Map<String, ITraceabilityStrategy> traceabilityStrategies = new HashMap<String, ITraceabilityStrategy>();

    public ITraceabilityStrategy getTraceabilityStrategy(Session session) {
        return this.traceabilityStrategies.get(session.getID());
    }

    public void notifyAddSession(Session newSession) {
        this.registerTraceabilityStrategy(newSession);
    }

    public void registerTraceabilityStrategy(Session session) {
        this.traceabilityStrategies.put(session.getID(), new SessionTraceabilityStrategy(session, new SessionModelDataProvider(session, new SessionModelTranslationScope(session))));
    }

    public void notifyRemoveSession(Session removedSession) {
        this.traceabilityStrategies.remove(removedSession.getID());
    }

    public void viewpointSelected(Viewpoint selectedSirius) {
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
    }

    public void notify(Session updated, int notification) {
    }
}

