/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.traceability;

import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.dsl.traceability.Domain;
import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.ILink;
import fr.obeo.dsl.traceability.LinkDirection;
import fr.obeo.dsl.traceability.LinkRange;
import fr.obeo.dsl.traceability.LinkSnapshot;
import fr.obeo.dsl.traceability.LinkType;
import fr.obeo.dsl.traceability.LinksByModelObjectId;
import fr.obeo.dsl.traceability.SynchronizationPoint;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.TraceabilityFactory;
import fr.obeo.dsl.traceability.TraceabilitySnapshot;
import fr.obeo.dsl.traceability.UriPrefix;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryStrategy;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryUpdater;
import fr.obeo.dsl.traceability.api.ISnapshotComparison;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.api.IModelDataProvider;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.impl.traceability.SessionArtifactRepositoryUpdater;
import fr.obeo.perseus.client.impl.traceability.SessionTraceabilityStrategy;
import fr.obeo.perseus.client.impl.traceability.SnapshotCompare;
import fr.obeo.perseus.client.util.LinkRangeSupport;
import fr.obeo.perseus.client.util.NamespaceHelper;
import fr.obeo.perseus.client.util.URIRef;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class SessionArtifactRepositoryStrategy
implements IArtifactRepositoryStrategy {
    private final ITraceabilityStrategy traceabilityStrategy;
    private final String artifactRepositoryURL;
    private final IModelDataProvider modelDataProvider;
    private IArtifactRepositoryUpdater artifactRepositoryUpdater;

    public SessionArtifactRepositoryStrategy(ITraceabilityStrategy traceabilityStrategy, IModelDataProvider modelDataProvider, String artifactRepositoryURL) {
        this.traceabilityStrategy = Objects.requireNonNull(traceabilityStrategy);
        this.modelDataProvider = Objects.requireNonNull(modelDataProvider);
        this.artifactRepositoryURL = Objects.requireNonNull(artifactRepositoryURL);
    }

    public String getArtifactRepositoryURL() {
        return this.artifactRepositoryURL;
    }

    public Optional<IArtifactRepositoryUpdater> findArtifactRepositoryUpdater() {
        if (this.artifactRepositoryUpdater == null) {
            this.artifactRepositoryUpdater = this.findArtifactRepository().map(repo -> new SessionArtifactRepositoryUpdater(this, (ArtifactRepository)repo, this.modelDataProvider)).orElse(null);
        }
        return Optional.ofNullable(this.artifactRepositoryUpdater);
    }

    public IArtifactRepositoryUpdater createArtifactRepositoryUpdater() throws IllegalStateException {
        if (this.artifactRepositoryUpdater == null) {
            Traceability traceability = (Traceability)this.traceabilityStrategy.findTraceability().orElseThrow(() -> new IllegalStateException("No traceability exists in the current session. Please create and initialize the traceability properly."));
            if (this.findArtifactRepository(traceability).isPresent()) {
                throw new IllegalStateException("The artifact repository already exists.");
            }
            ArtifactRepository artifactRepository = this.createArtifactRepository(traceability);
            this.artifactRepositoryUpdater = new SessionArtifactRepositoryUpdater(this, artifactRepository, this.modelDataProvider);
        }
        return this.artifactRepositoryUpdater;
    }

    public ISnapshotComparison compareWithLatestSnapshot(TraceabilitySnapshot newSnapshot) throws CoreException {
        Optional<ArtifactRepository> optRepository = this.findArtifactRepository();
        if (optRepository.isPresent()) {
            ArtifactRepository artifactRepository = optRepository.get();
            Traceability traceability = (Traceability)artifactRepository.eContainer();
            TraceabilitySnapshot lastAncestorSnapshot = this.findAncestorSnapshot(artifactRepository).orElse(TraceabilityFactory.eINSTANCE.createTraceabilitySnapshot());
            try {
                Map<String, String> preferredPrefixes = traceability.getDomains().stream().filter(SessionTraceabilityStrategy::isValid).collect(Collectors.toMap(dom -> dom.getPrefix(), dom -> dom.getUri()));
                NamespaceHelper nsHelper = new NamespaceHelper(preferredPrefixes);
                return new SnapshotCompare(nsHelper).compare(lastAncestorSnapshot, newSnapshot);
            }
            catch (OperationCanceledException e) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new CoreException((IStatus)new Status(4, "fr.obeo.perseus.client", "Exception while comparing current state with ancestor state.", (Throwable)e));
            }
        }
        NamespaceHelper nsHelper = new NamespaceHelper(Collections.emptyMap());
        try {
            return new SnapshotCompare(nsHelper).compare(TraceabilityFactory.eINSTANCE.createTraceabilitySnapshot(), newSnapshot);
        }
        catch (OperationCanceledException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "fr.obeo.perseus.client", "Exception while comparing current state with ancestor state.", (Throwable)e));
        }
    }

    public TraceabilitySnapshot computeSnapshot() {
        TraceabilitySnapshot snapshot = TraceabilityFactory.eINSTANCE.createTraceabilitySnapshot();
        snapshot.setTimestamp(Instant.now());
        this.findArtifactRepository().ifPresent(artifactRepository -> {
            TreeIterator allContents = artifactRepository.eAllContents();
            Map<String, String> preferredPrefixes = ((Traceability)artifactRepository.eContainer()).getDomains().stream().filter(SessionTraceabilityStrategy::isValid).collect(Collectors.toMap(Domain::getPrefix, Domain::getUri));
            NamespaceHelper nsHelper = new NamespaceHelper(preferredPrefixes);
            LinkedHashMap<String, LinksByModelObjectId> links = new LinkedHashMap<String, LinksByModelObjectId>();
            while (allContents.hasNext()) {
                String objectId;
                ILink link;
                EObject next = (EObject)allContents.next();
                if (!(next instanceof ILink) || !LinkDirection.MODEL_TO_ARTIFACT.equals((Object)(link = (ILink)next).getDirection())) continue;
                EObject modelObject = link.getModelObject();
                IArtifact artifact = link.getArtifact();
                if (modelObject == null || artifact == null || artifact.getUrl() == null || !this.getTranslationScope().isInModel(modelObject) || (objectId = this.getTranslationScope().getId(modelObject)) == null) continue;
                LinkSnapshot linkSnapshot = TraceabilityFactory.eINSTANCE.createLinkSnapshot();
                linkSnapshot.setArtifactURL(artifact.getUrl());
                linkSnapshot.setDirection(LinkDirection.MODEL_TO_ARTIFACT);
                LinkType type = link.getType();
                URIRef uriRef = new URIRef(URI.create(type.getUri()));
                String typeName = nsHelper.asPrefixedName(uriRef.getPrefix(), uriRef.getLocalName());
                linkSnapshot.setTypeName(typeName);
                links.computeIfAbsent(objectId, oid -> {
                    LinksByModelObjectId result = TraceabilityFactory.eINSTANCE.createLinksByModelObjectId();
                    result.setKey(objectId);
                    return result;
                }).getValue().add((Object)linkSnapshot);
            }
            snapshot.getLinksByModelObjectId().addAll(links.values());
            nsHelper.getKnownURIsByPrefix().entrySet().stream().forEach(e -> {
                UriPrefix prefix = TraceabilityFactory.eINSTANCE.createUriPrefix();
                prefix.setKey((String)e.getKey());
                prefix.setValue((String)e.getValue());
                snapshot.getUriPrefixes().add((Object)prefix);
            });
        });
        return snapshot;
    }

    public Optional<IArtifact> findArtifact(String artifactURL) {
        return this.findArtifactRepository().map(repo -> {
            TreeIterator eAllContents = repo.eAllContents();
            while (eAllContents.hasNext()) {
                IArtifact artifact;
                EObject next = (EObject)eAllContents.next();
                if (!(next instanceof IArtifact) || !artifactURL.equals((artifact = (IArtifact)next).getUrl())) continue;
                return artifact;
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public Optional<ILink> findLink(String modelObjectId, LinkType linkType, IArtifact artifact, LinkDirection direction) {
        TreeIterator it = artifact.eAllContents();
        while (it.hasNext()) {
            ILink link;
            EObject next = (EObject)it.next();
            if (!(next instanceof ILink) || (link = (ILink)next).getModelObject() == null || !modelObjectId.equals(this.modelDataProvider.getTranslationScope().getId(link.getModelObject())) || linkType != link.getType() || artifact != link.getArtifact() || link.getDirection() != direction) continue;
            return Optional.of(link);
        }
        return Optional.empty();
    }

    public Optional<ILink> findLink(EObject modelObject, LinkType linkType, IArtifact artifact, LinkDirection direction) {
        TreeIterator it = artifact.eAllContents();
        while (it.hasNext()) {
            ILink link;
            EObject next = (EObject)it.next();
            if (!(next instanceof ILink) || modelObject != (link = (ILink)next).getModelObject() || linkType != link.getType() || artifact != link.getArtifact() || link.getDirection() != direction) continue;
            return Optional.of(link);
        }
        return Optional.empty();
    }

    public IModelTranslationScope getTranslationScope() {
        return this.modelDataProvider.getTranslationScope();
    }

    public Optional<ArtifactRepository> findArtifactRepository() {
        return this.traceabilityStrategy.findTraceability().flatMap(this::findArtifactRepository);
    }

    protected Optional<ArtifactRepository> findArtifactRepository(Traceability t) {
        return t.getRepositories().stream().filter(repo -> this.artifactRepositoryURL.equals(repo.getUrl())).findFirst();
    }

    public ITraceabilityStrategy getTraceabilityStrategy() {
        return this.traceabilityStrategy;
    }

    public Optional<TraceabilitySnapshot> findLatestSnapshot() {
        return this.findArtifactRepository().flatMap(this::findAncestorSnapshot);
    }

    private Optional<TraceabilitySnapshot> findAncestorSnapshot(ArtifactRepository artifactRepository) {
        Optional latestPoint = this.traceabilityStrategy.findTraceability().flatMap(t -> Optional.ofNullable(t.getLatestSynchronizationPoint()));
        Optional<TraceabilitySnapshot> result = Optional.empty();
        if (latestPoint.isPresent()) {
            result = ((SynchronizationPoint)latestPoint.get()).getTraceabilitySnapshots().stream().filter(snapshot -> artifactRepository.getSnapshots().contains(snapshot)).findAny();
        } else {
            EList snapshots = artifactRepository.getSnapshots();
            if (!snapshots.isEmpty()) {
                result = Optional.of((TraceabilitySnapshot)snapshots.get(snapshots.size() - 1));
            }
        }
        return result;
    }

    private ArtifactRepository createArtifactRepository(Traceability traceability) {
        ArtifactRepository result = TraceabilityFactory.eINSTANCE.createArtifactRepository();
        traceability.getRepositories().add((Object)result);
        result.setUrl(this.artifactRepositoryURL);
        return result;
    }

    public Set<LinkType> getSupportedLinkTypes(EObject modelObject, Set<String> artifactTypeURIs, LinkDirection direction) {
        return this.findArtifactRepository().map(rep -> rep.getLinkRanges().stream().filter(LinkRangeSupport.isValidForDirection(direction)).filter(LinkRangeSupport.isValidForAnyTypeIn(artifactTypeURIs)).filter(LinkRangeSupport.isValidForTarget(modelObject)).map(LinkRange::getLinkType).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }
}

