/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.traceability;

import fr.obeo.dsl.traceability.Artifact;
import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.dsl.traceability.ArtifactStore;
import fr.obeo.dsl.traceability.ArtifactType;
import fr.obeo.dsl.traceability.Domain;
import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.ILink;
import fr.obeo.dsl.traceability.Link;
import fr.obeo.dsl.traceability.LinkDirection;
import fr.obeo.dsl.traceability.LinkType;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.TraceabilityFactory;
import fr.obeo.dsl.traceability.TraceabilitySnapshot;
import fr.obeo.dsl.traceability.api.IArtifactDescriptor;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryChangeSet;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryStrategy;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryUpdater;
import fr.obeo.dsl.traceability.api.ILinkDescriptor;
import fr.obeo.dsl.traceability.api.ISnapshotDiffAction;
import fr.obeo.dsl.traceability.api.ISnapshotDifference;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IModelDataProvider;
import fr.obeo.perseus.client.impl.traceability.SessionTraceabilityStrategy;
import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class SessionArtifactRepositoryUpdater
implements IArtifactRepositoryUpdater {
    private final IArtifactRepositoryStrategy strategy;
    private final Traceability traceability;
    private final ArtifactRepository artifactRepository;
    private final IModelDataProvider modelDataProvider;

    public SessionArtifactRepositoryUpdater(IArtifactRepositoryStrategy strategy, ArtifactRepository artifactRepository, IModelDataProvider modelDataProvider) {
        this.strategy = Objects.requireNonNull(strategy);
        this.artifactRepository = Objects.requireNonNull(artifactRepository);
        this.modelDataProvider = Objects.requireNonNull(modelDataProvider);
        this.traceability = (Traceability)artifactRepository.eContainer();
    }

    public TraceabilitySnapshot applyChanges(IArtifactRepositoryChangeSet artifactRepositoryChangeSet, Instant timestamp) {
        List diffsToAccept = artifactRepositoryChangeSet.getDiffActions().stream().filter(a -> a.getAction() == ISnapshotDiffAction.DiffAction.ACCEPT).collect(Collectors.toList());
        if (!diffsToAccept.isEmpty()) {
            LinkedHashSet<IArtifact> updatedArtifacts = new LinkedHashSet<IArtifact>();
            for (ISnapshotDiffAction diffToAccept : diffsToAccept) {
                this.applyChange(updatedArtifacts, diffToAccept);
            }
        }
        TraceabilitySnapshot result = artifactRepositoryChangeSet.toTraceabilitySnapshot();
        this.artifactRepository.getSnapshots().clear();
        this.artifactRepository.getSnapshots().add((Object)result);
        this.traceability.getLatestSynchronizationPoint().getTraceabilitySnapshots().add((Object)result);
        return result;
    }

    private void applyChange(Set<IArtifact> updatedArtifacts, ISnapshotDiffAction diffToAccept) {
        ISnapshotDifference diff = diffToAccept.getDifference();
        ILinkDescriptor linkDescriptor = diff.getLinkDescriptor();
        String linkTypeURI = linkDescriptor.getTypeDescriptor().getURI();
        LinkType linkType = (LinkType)this.strategy.getTraceabilityStrategy().findLinkType(linkTypeURI).orElseThrow(() -> {
            Optional<Domain> domain = this.traceability.getDomains().stream().filter(SessionTraceabilityStrategy::isValid).filter(dom -> linkDescriptor.getTypeDescriptor().getNsURI().equals(dom.getUri())).findAny();
            if (domain.isPresent()) {
                return new IllegalStateException(String.format("There is no link type with URI '%s'. \n\nTo acknowledge this type of links you must create a Link Type '%s' in the traceability model, in the Domain '%s'.", linkTypeURI, linkDescriptor.getTypeDescriptor().getName(), domain.get().getName()));
            }
            return new IllegalStateException(String.format("There is no link type with URI '%s'. \n\nTo acknowledge this type of links you must first create a Domain with uri '%s' in the traceability model, then create a Link Type '%s' under it.", linkTypeURI, linkDescriptor.getTypeDescriptor().getNsURI(), linkDescriptor.getTypeDescriptor().getName()));
        });
        switch (diff.getKind()) {
            case ADD: {
                Optional<EObject> optSource = this.modelDataProvider.findSemanticObjectById(linkDescriptor.getModelObjectId());
                if (optSource.isPresent()) {
                    IArtifact artifact = this.strategy.findArtifact(linkDescriptor.getArtifactURL()).map(art -> {
                        if (updatedArtifacts.add((IArtifact)art)) {
                            this.update((IArtifact)art, diffToAccept.getArtifactDescriptor());
                        }
                        return art;
                    }).orElseGet(() -> {
                        IArtifactDescriptor artifactDescriptor = diffToAccept.getArtifactDescriptor();
                        IArtifact newArtifact = this.strategy.findArtifactRepositoryUpdater().map(updater -> updater.createArtifact(artifactDescriptor)).orElseThrow(() -> new IllegalStateException(String.format("The Artifact repository '%s' does not exist", this.strategy.getArtifactRepositoryURL())));
                        return newArtifact;
                    });
                    LinkDirection direction = LinkDirection.MODEL_TO_ARTIFACT;
                    if (linkDescriptor.isIncoming()) {
                        direction = LinkDirection.ARTIFACT_TO_MODEL;
                    }
                    if (this.strategy.linkExists(optSource.get(), linkType, artifact, direction)) break;
                    this.createLink(optSource.get(), linkType, direction, artifact);
                    break;
                }
                if (PerseusClientPlugin.getPlugin() == null) break;
                PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client", String.format("Unable to ADD link '%s' between model element with ID '%s' and artifact '%s'\nbecause the model element cannot be found (Probably because it has been deleted from the model).\nThis link will be deleted from the Publication server next time this model is published", linkDescriptor.getTypeDescriptor().getName(), linkDescriptor.getModelObjectId(), linkDescriptor.getArtifactURL())));
                break;
            }
            case DELETE: {
                Optional optArtifact = this.strategy.findArtifact(linkDescriptor.getArtifactURL());
                if (optArtifact.isPresent()) {
                    Optional optLink;
                    IArtifact art2 = (IArtifact)optArtifact.get();
                    if (updatedArtifacts.add(art2)) {
                        this.update(art2, diffToAccept.getArtifactDescriptor());
                    }
                    if ((optLink = this.strategy.findLink(linkDescriptor.getModelObjectId(), linkType, art2, linkDescriptor.isIncoming() ? LinkDirection.ARTIFACT_TO_MODEL : LinkDirection.MODEL_TO_ARTIFACT)).isPresent()) {
                        EcoreUtil.delete((EObject)((EObject)optLink.get()));
                        break;
                    }
                    if (PerseusClientPlugin.getPlugin() == null) break;
                    PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", String.format("Ignored the DELETE of link '%s' between model element with ID '%s' and artifact '%s'\nbecause the link did not exist (Probably because it has been manually deleted).", linkDescriptor.getTypeDescriptor().getName(), linkDescriptor.getModelObjectId(), linkDescriptor.getArtifactURL())));
                    break;
                }
                if (PerseusClientPlugin.getPlugin() == null) break;
                PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", String.format("Ignored the DELETE of link '%s' between model element with ID '%s' and artifact '%s'\nbecause this artifact is not present in the traceability model, which means this link has already been deleted.", linkDescriptor.getTypeDescriptor().getName(), linkDescriptor.getModelObjectId(), linkDescriptor.getArtifactURL())));
                break;
            }
            default: {
                if (PerseusClientPlugin.getPlugin() == null) break;
                PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(4, "fr.obeo.perseus.client", String.format("Ignored unsupported difference of kind %s for a link '%s' between model element with ID '%s' and artifact '%s'.", diff.getKind(), linkDescriptor.getTypeDescriptor().getName(), linkDescriptor.getModelObjectId(), linkDescriptor.getArtifactURL())));
            }
        }
    }

    private void update(IArtifact artifact, IArtifactDescriptor artifactDescriptor) {
        if (artifactDescriptor != null) {
            if (!artifact.getUrl().equals(artifactDescriptor.getArtifactURL())) {
                throw new IllegalStateException("The artifact descriptor must have the same URL as the artifact to update.");
            }
            artifact.setTitle(artifactDescriptor.getTitle());
            artifact.setIdentifier(artifactDescriptor.getId());
            artifactDescriptor.getSourceURL().ifPresent(sourceURL -> artifact.setSourceURL(sourceURL));
            Set artifactTypes = artifactDescriptor.getTypeDescriptors().stream().map(td -> this.strategy.getTraceabilityStrategy().findArtifactType(td.getURI()).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
            Iterator it = artifact.getTypes().iterator();
            while (it.hasNext()) {
                ArtifactType type = (ArtifactType)it.next();
                if (artifactTypes.contains(type)) continue;
                it.remove();
            }
            artifact.getTypes().addAll(artifactTypes);
        }
    }

    public IArtifact createArtifact(IArtifactDescriptor artifactDescriptor) {
        Artifact artifact = TraceabilityFactory.eINSTANCE.createArtifact();
        artifact.setUrl(artifactDescriptor.getArtifactURL());
        this.update((IArtifact)artifact, artifactDescriptor);
        ArtifactStore store = this.getArtifactRepository().getStore();
        if (store == null) {
            store = TraceabilityFactory.eINSTANCE.createArtifactStore();
            this.getArtifactRepository().setStore(store);
        }
        store.getOwnedArtifacts().add((Object)artifact);
        return artifact;
    }

    public ILink createLink(EObject modelObject, LinkType linkType, LinkDirection direction, IArtifact artifact) {
        Link link = TraceabilityFactory.eINSTANCE.createLink();
        link.setDirection(direction);
        link.setArtifact(artifact);
        link.setModelObject(modelObject);
        link.setDirection(direction);
        link.setType(linkType);
        artifact.getOwnedLinks().add((Object)link);
        return link;
    }

    public Traceability getTraceability() {
        return this.traceability;
    }

    public ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    public IArtifactRepositoryStrategy getStrategy() {
        return this.strategy;
    }
}

