/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.traceability;

import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.dsl.traceability.ArtifactType;
import fr.obeo.dsl.traceability.Domain;
import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.ILink;
import fr.obeo.dsl.traceability.LinkDirection;
import fr.obeo.dsl.traceability.LinkType;
import fr.obeo.dsl.traceability.PublicationSettings;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.TraceabilityFactory;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryChangeSet;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryStrategy;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryUpdater;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.dsl.traceability.edit.commands.SetTraceabilityLatestSynchronizationPoint;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IModelDataProvider;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.impl.commands.ApplyTraceabilityChangesCommand;
import fr.obeo.perseus.client.impl.traceability.SessionArtifactRepositoryStrategy;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;

public class SessionTraceabilityStrategy
extends AdapterImpl
implements ITraceabilityStrategy {
    private final Session session;
    private final IModelDataProvider modelDataProvider;

    public SessionTraceabilityStrategy(Session session, IModelDataProvider modelDataProvider) {
        this.session = Objects.requireNonNull(session);
        this.modelDataProvider = Objects.requireNonNull(modelDataProvider);
    }

    public Session getSession() {
        return this.session;
    }

    public IModelTranslationScope getTranslationScope() {
        return this.modelDataProvider.getTranslationScope();
    }

    public Optional<Traceability> findTraceability() {
        return this.session.getSemanticResources().stream().filter(res -> res.getURI() != null && "traceability".equals(res.getURI().fileExtension())).flatMap(res -> res.getContents().stream().filter(Traceability.class::isInstance).map(Traceability.class::cast)).findFirst();
    }

    public IArtifactRepositoryStrategy getRepositoryStrategy(String repositoryURL) {
        return new SessionArtifactRepositoryStrategy(this, this.modelDataProvider, repositoryURL);
    }

    public boolean isAdapterForType(Object type) {
        if (type == ITraceabilityStrategy.class) {
            return true;
        }
        return super.isAdapterForType(type);
    }

    public Optional<LinkType> findLinkType(String typeURI) {
        return this.findTraceability().flatMap(t -> t.getDomains().stream().flatMap(dom -> dom.getOwnedLinkTypes().stream()).filter(linkType -> typeURI.equals(linkType.getUri())).findFirst());
    }

    public Optional<ArtifactType> findArtifactType(String typeURI) {
        return this.findTraceability().flatMap(t -> t.getDomains().stream().flatMap(dom -> dom.getOwnedArtifactTypes().stream()).filter(type -> typeURI.equals(type.getUri())).findFirst());
    }

    public Collection<IArtifact> getAllArtifacts() {
        return this.findTraceability().map(traceability -> {
            ArrayList<IArtifact> result = new ArrayList<IArtifact>();
            TreeIterator it = traceability.eAllContents();
            while (it.hasNext()) {
                EObject next = (EObject)it.next();
                if (next instanceof IArtifact) {
                    result.add((IArtifact)next);
                    continue;
                }
                if (!(next instanceof Domain)) continue;
                it.prune();
            }
            return result;
        }).orElseGet(Collections::emptyList);
    }

    public Collection<ILink> getLinks(EObject modelObject, LinkDirection linkDirection) {
        return this.findTraceability().map(traceability -> {
            ArrayList<ILink> result = new ArrayList<ILink>();
            TreeIterator it = traceability.eAllContents();
            while (it.hasNext()) {
                EObject next = (EObject)it.next();
                if (next instanceof ILink && ((ILink)next).getModelObject() == modelObject) {
                    if (linkDirection != null && linkDirection != ((ILink)next).getDirection()) continue;
                    result.add((ILink)next);
                    continue;
                }
                if (!(next instanceof Domain)) continue;
                it.prune();
            }
            return result;
        }).orElseGet(Collections::emptyList);
    }

    public Set<IArtifact> getArtifactsLinkedTo(EObject modelObject, LinkDirection linkDirection) {
        return this.findTraceability().map(traceability -> {
            LinkedHashSet result = new LinkedHashSet();
            TreeIterator it = traceability.eAllContents();
            while (it.hasNext()) {
                EObject next = (EObject)it.next();
                if (next instanceof ILink && ((ILink)next).getModelObject() == modelObject) {
                    if (linkDirection != null) {
                        if (linkDirection != ((ILink)next).getDirection()) continue;
                    }
                    Optional.ofNullable(((ILink)next).getArtifact()).ifPresent(result::add);
                    continue;
                }
                if (!(next instanceof Domain)) continue;
                it.prune();
            }
            return result;
        }).orElseGet(Collections::emptySet);
    }

    public void applyChanges(List<? extends IArtifactRepositoryChangeSet> linkChangesModelsByFriend, Instant timestamp) {
        if (linkChangesModelsByFriend.isEmpty()) {
            return;
        }
        CompoundCommand command = new CompoundCommand("Synchronize with remote links");
        command.append((Command)new SetTraceabilityLatestSynchronizationPoint(this.session.getTransactionalEditingDomain(), "Set Latest Synchronization Point", this.getTraceabilityStrategy(), timestamp));
        for (IArtifactRepositoryChangeSet iArtifactRepositoryChangeSet : linkChangesModelsByFriend) {
            IArtifactRepositoryStrategy repositoryStrategy = this.getRepositoryStrategy(iArtifactRepositoryChangeSet.getRepositoryUrl());
            String cmdLabel = String.format("Synchronize with links to repository %s", iArtifactRepositoryChangeSet.getRepositoryUrl());
            ApplyTraceabilityChangesCommand repoCmd = new ApplyTraceabilityChangesCommand(this.session.getTransactionalEditingDomain(), cmdLabel, repositoryStrategy, timestamp, iArtifactRepositoryChangeSet);
            command.append((Command)repoCmd);
        }
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
    }

    private ITraceabilityStrategy getTraceabilityStrategy() {
        return (ITraceabilityStrategy)Adapters.adapt((Object)this.session, ITraceabilityStrategy.class);
    }

    public Traceability createTraceability(IProgressMonitor monitor) {
        if (this.findTraceability().isPresent()) {
            throw new IllegalStateException("Traceability already exists");
        }
        final Resource resource = this.getResourceToUseAsTemplate();
        final URI traceabilityURI = resource.getURI().trimFileExtension().appendFileExtension("traceability");
        CompoundCommand cc = new CompoundCommand("Create Traceability Resource");
        cc.append((Command)new RecordingCommand(this.session.getTransactionalEditingDomain(), "Create Traceability File"){

            protected void doExecute() {
                Resource traceabilityResource = resource.getResourceSet().createResource(traceabilityURI);
                Traceability result = TraceabilityFactory.eINSTANCE.createTraceability();
                traceabilityResource.getContents().add((Object)result);
                PublicationSettings publicationSettings = TraceabilityFactory.eINSTANCE.createPublicationSettings();
                result.setPublicationSettings(publicationSettings);
                try {
                    traceabilityResource.save(null);
                }
                catch (IOException e) {
                    PerseusClientPlugin.getPlugin().logError("Initialize traceability settings failed: " + e.getMessage(), e);
                }
            }
        });
        cc.append((Command)new AddSemanticResourceCommand(this.session, traceabilityURI, null));
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)cc);
        return this.findTraceability().orElse(null);
    }

    private Resource getResourceToUseAsTemplate() {
        return this.session.getSemanticResources().stream().filter(res -> res.getURI() != null && res.getURI().toString().startsWith("cdo:")).findFirst().orElseGet(() -> ((Session)this.session).getSessionResource());
    }

    public IArtifactRepositoryUpdater getRepositoryUpdater(ArtifactRepository repository) throws IllegalArgumentException {
        IArtifactRepositoryStrategy repositoryStrategy = this.getRepositoryStrategy(repository.getUrl());
        return (IArtifactRepositoryUpdater)repositoryStrategy.findArtifactRepositoryUpdater().orElseThrow(() -> new IllegalArgumentException("The given repository does not belong to this Traceability model."));
    }

    public static boolean isValid(Domain domain) {
        boolean result = false;
        if (domain.getUri() != null && domain.getPrefix() != null) {
            try {
                new java.net.URI(domain.getUri());
                result = domain.getPrefix().matches("[A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}&&[^:]][A-Z_a-z\\-\\.0-9\\xB7\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02FF\\u0300-\\u036F\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u203F-\\u2040\\u2070-\\u218F\\u2C00\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{10FFFF}&&[^:]]*");
            }
            catch (URISyntaxException e) {
                result = false;
            }
        }
        return result;
    }

    public static boolean isValid(ArtifactRepository repo) {
        return repo.getUrl() != null;
    }
}

