/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.traceability;

import fr.obeo.dsl.traceability.LinkSnapshot;
import fr.obeo.dsl.traceability.LinksByModelObjectId;
import fr.obeo.dsl.traceability.TraceabilitySnapshot;
import fr.obeo.dsl.traceability.UriPrefix;
import fr.obeo.dsl.traceability.api.INamespaceHelper;
import fr.obeo.dsl.traceability.api.ISnapshotComparison;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.dto.PName;
import fr.obeo.perseus.client.impl.traceability.LinkDescriptor;
import fr.obeo.perseus.client.impl.traceability.SnapshotComparison;
import fr.obeo.perseus.client.impl.traceability.SnapshotDifference;
import fr.obeo.perseus.client.util.NamespaceHelper;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SnapshotCompare {
    private final INamespaceHelper namespaceHelper;

    public SnapshotCompare(INamespaceHelper namespaceHelper) {
        this.namespaceHelper = namespaceHelper;
    }

    public ISnapshotComparison compare(TraceabilitySnapshot left, TraceabilitySnapshot right) throws MalformedURLException, URISyntaxException {
        SnapshotComparison.Builder comparisonBuilder = SnapshotComparison.builder(left, right, this.namespaceHelper);
        Map<String, LinkDescriptor> leftMap = this.indexByHash(left);
        Map<String, LinkDescriptor> rightMap = this.indexByHash(right);
        for (Map.Entry<String, LinkDescriptor> entry : leftMap.entrySet()) {
            if (rightMap.containsKey(entry.getKey())) continue;
            comparisonBuilder.addDifference(SnapshotDifference.delete(entry.getValue()));
        }
        for (Map.Entry<String, LinkDescriptor> entry : rightMap.entrySet()) {
            if (leftMap.containsKey(entry.getKey())) continue;
            comparisonBuilder.addDifference(SnapshotDifference.add(entry.getValue()));
        }
        return comparisonBuilder.build();
    }

    public Map<String, LinkDescriptor> indexByHash(TraceabilitySnapshot traceabilitySnapshot) throws MalformedURLException, URISyntaxException {
        HashMap<String, LinkDescriptor> linkDescriptorsByHash = new HashMap<String, LinkDescriptor>();
        for (LinksByModelObjectId entry : traceabilitySnapshot.getLinksByModelObjectId()) {
            String objectId = entry.getKey();
            for (LinkSnapshot linkSnapshot : entry.getValue()) {
                PName pName = PName.of(linkSnapshot.getTypeName());
                Map<String, String> map = new NamespaceHelper((Collection<UriPrefix>)traceabilitySnapshot.getUriPrefixes()).getPreferredPrefixesByURI();
                String linkTypeNsURI = map.get(pName.getPrefix());
                if (linkTypeNsURI == null && PerseusClientPlugin.getPlugin() != null) {
                    PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client", String.format("Found link snapshot whose type name has no corresponding NsURI: '%s'", linkSnapshot.getTypeName())));
                    continue;
                }
                LinkDescriptor descriptor = LinkDescriptor.builder().modelObjectId(objectId).linkType(linkTypeNsURI, pName.getName()).artifact(linkSnapshot.getArtifactURL()).build();
                linkDescriptorsByHash.put(this.toString(descriptor.getHash()), descriptor);
            }
        }
        return linkDescriptorsByHash;
    }

    private String toString(byte[] digest) {
        StringBuilder hashBuilder = new StringBuilder(digest.length);
        int i = 0;
        while (i < digest.length) {
            hashBuilder.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return hashBuilder.toString();
    }
}

