/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.traceability;

import fr.obeo.dsl.traceability.TraceabilitySnapshot;
import fr.obeo.dsl.traceability.api.INamespaceHelper;
import fr.obeo.dsl.traceability.api.ISnapshotComparison;
import fr.obeo.dsl.traceability.api.ISnapshotDifference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class SnapshotComparison
implements ISnapshotComparison {
    private final TraceabilitySnapshot left;
    private final TraceabilitySnapshot right;
    private final INamespaceHelper namespaceHelper;
    private final Collection<? extends ISnapshotDifference> differences;

    private SnapshotComparison(TraceabilitySnapshot left, TraceabilitySnapshot right, Collection<? extends ISnapshotDifference> differences, INamespaceHelper namespaceHelper) {
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
        this.namespaceHelper = Objects.requireNonNull(namespaceHelper);
        this.differences = Collections.unmodifiableCollection(new ArrayList<ISnapshotDifference>(differences));
    }

    public TraceabilitySnapshot getLeft() {
        return this.left;
    }

    public TraceabilitySnapshot getRight() {
        return this.right;
    }

    public Iterable<? extends ISnapshotDifference> getDifferences() {
        return this.differences;
    }

    public int getSize() {
        return this.differences.size();
    }

    public INamespaceHelper getNamespaceHelper() {
        return this.namespaceHelper;
    }

    public static Builder builder(TraceabilitySnapshot left, TraceabilitySnapshot right, INamespaceHelper namespaceHelper) {
        return new Builder(left, right, namespaceHelper);
    }

    /* synthetic */ SnapshotComparison(TraceabilitySnapshot traceabilitySnapshot, TraceabilitySnapshot traceabilitySnapshot2, Collection collection, INamespaceHelper iNamespaceHelper, SnapshotComparison snapshotComparison) {
        this(traceabilitySnapshot, traceabilitySnapshot2, collection, iNamespaceHelper);
    }

    public static final class Builder {
        private final TraceabilitySnapshot left;
        private final TraceabilitySnapshot right;
        private final INamespaceHelper namespaceHelper;
        private List<ISnapshotDifference> differences = new ArrayList<ISnapshotDifference>(256);

        private Builder(TraceabilitySnapshot left, TraceabilitySnapshot right, INamespaceHelper namespaceHelper) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
            this.namespaceHelper = Objects.requireNonNull(namespaceHelper);
        }

        public Builder addDifference(ISnapshotDifference difference) {
            this.differences.add(difference);
            return this;
        }

        public SnapshotComparison build() {
            return new SnapshotComparison(this.left, this.right, this.differences, this.namespaceHelper, null);
        }
    }
}

