/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.traceability;

import fr.obeo.dsl.traceability.api.IArtifactDescriptor;
import fr.obeo.dsl.traceability.api.ISnapshotDiffAction;
import fr.obeo.dsl.traceability.api.ISnapshotDifference;
import java.util.Objects;
import java.util.Optional;

public class SnapshotDiffAction
implements ISnapshotDiffAction {
    private final ISnapshotDifference diff;
    private final IArtifactDescriptor artifactDescriptor;
    private ISnapshotDiffAction.DiffAction action = ISnapshotDiffAction.DiffAction.ACCEPT;

    public SnapshotDiffAction(ISnapshotDifference diff, IArtifactDescriptor artifactDescriptor) {
        this.diff = Objects.requireNonNull(diff);
        this.artifactDescriptor = Objects.requireNonNull(artifactDescriptor);
        if (!artifactDescriptor.getArtifactURL().equals(diff.getLinkDescriptor().getArtifactURL())) {
            throw new IllegalStateException("The artifact URL of the artifact descriptor does not match that of the link difference.");
        }
    }

    public void setAction(ISnapshotDiffAction.DiffAction action) {
        this.action = Optional.ofNullable(action).orElse(ISnapshotDiffAction.DiffAction.ACCEPT);
    }

    public ISnapshotDifference getDifference() {
        return this.diff;
    }

    public IArtifactDescriptor getArtifactDescriptor() {
        return this.artifactDescriptor;
    }

    public ISnapshotDiffAction.DiffAction getAction() {
        return this.action;
    }

    public boolean canAccept() {
        return true;
    }

    public boolean canReject() {
        return true;
    }
}

