/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.traceability.jazz;

import fr.obeo.dsl.traceability.UrlPattern;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.impl.graphql.GQLOAuthFriend;
import fr.obeo.perseus.client.impl.traceability.AbstractUrlPatternProvider;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DoorsNextUrlPatternProvider
extends AbstractUrlPatternProvider {
    @Override
    public List<UrlPattern> getDefaultUrlPatterns(GQLOAuthFriend friend) {
        if (friend.getRootServicesURI().endsWith("/rm/rootservices")) {
            String hostUrl = this.extractHostUrl(friend);
            try {
                String encodedHostUrl = URLEncoder.encode(hostUrl, "UTF-8");
                return Arrays.asList(this.createUrlPattern("DOORS Next drag&drop defaults", "\\Q" + hostUrl + "/rm/web#\\E(?:[^&]+&(:?amp;)?)*\\QartifactURI=" + encodedHostUrl + "%2Frm%2Fresources%2F\\E(?<item>[a-zA-Z0-9\\-\\_]+).*", String.valueOf(hostUrl) + "/rm/resources/${item}"), this.createUrlPattern("DOORS Next copy/paste defaults", "\\Q" + hostUrl + "/rm/resources/\\E(?<item>[a-zA-Z0-9\\-\\_]+).*", String.valueOf(hostUrl) + "/rm/resources/${item}"));
            }
            catch (UnsupportedEncodingException e) {
                PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client", String.format("Unable to create URL pattern for '%s': invalid URL.", hostUrl)));
            }
        }
        return Collections.emptyList();
    }
}

