/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.util;

import fr.obeo.perseus.client.api.IArtifactID;
import java.util.Objects;

public final class ArtifactID
implements IArtifactID {
    private final String repositoryURL;
    private final String artifactURL;

    private ArtifactID(String repositoryURL, String artifactURL) {
        this.repositoryURL = Objects.requireNonNull(repositoryURL);
        this.artifactURL = Objects.requireNonNull(artifactURL);
    }

    @Override
    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    @Override
    public String getArtifactURL() {
        return this.artifactURL;
    }

    public String toString() {
        return String.format("'%s' from repository '%s'", this.artifactURL, this.repositoryURL);
    }

    public static ArtifactIDBuilder forRepository(String repositoryURL) {
        return new ArtifactIDBuilder(repositoryURL);
    }

    /* synthetic */ ArtifactID(String string, String string2, ArtifactID artifactID) {
        this(string, string2);
    }

    public static class ArtifactIDBuilder {
        private final String repositoryURL;

        public ArtifactIDBuilder(String repositoryURL) {
            this.repositoryURL = Objects.requireNonNull(repositoryURL);
        }

        public ArtifactID build(String artifactURL) {
            return new ArtifactID(this.repositoryURL, artifactURL, null);
        }
    }
}

