/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.sirius.viewpoint.DView;

public final class DViewComparator
implements Comparator<DView> {
    public static final DViewComparator INSTANCE = new DViewComparator();
    private static final List<String> DEFAULT_VIEW_POINTS_ORDER = Collections.unmodifiableList(Arrays.asList("Common", "Operational Analysis", "System Analysis", "Logical Architecture", "Physical Architecture", "EPBS architecture"));

    private DViewComparator() {
    }

    @Override
    public int compare(DView a, DView b) {
        int name2Index;
        String viewpointName1 = a.getViewpoint().getName();
        String viewpointName2 = b.getViewpoint().getName();
        int name1Index = DEFAULT_VIEW_POINTS_ORDER.indexOf(viewpointName1);
        if (name1Index == (name2Index = DEFAULT_VIEW_POINTS_ORDER.indexOf(viewpointName2))) {
            return viewpointName1.compareTo(viewpointName2);
        }
        name1Index = name1Index > -1 ? name1Index : Integer.MAX_VALUE;
        name2Index = name2Index > -1 ? name2Index : Integer.MAX_VALUE;
        return name1Index < name2Index ? -1 : 1;
    }
}

