/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.util;

import fr.obeo.perseus.client.util.Chronometer;
import java.time.Duration;

public class EstimatingChronometer
extends Chronometer {
    private int nbSteps;
    private int index;
    private int updateThreshold = 50;

    @Override
    public long start(String label) {
        this.index = 1;
        return super.start(label);
    }

    public void nextStep() {
        ++this.index;
    }

    public Duration remainingEstimate() {
        double speed = (double)this.index / (double)this.getMillisFromStart();
        double remainingEstimate = (double)(this.nbSteps - this.index) / speed;
        return Duration.ofMillis((long)remainingEstimate);
    }

    public int getNbSteps() {
        return this.nbSteps;
    }

    public void setNbSteps(int nbSteps) {
        this.nbSteps = nbSteps;
    }

    public int getIndex() {
        return this.index;
    }

    public int getUpdateThreshold() {
        return this.updateThreshold;
    }

    public void setUpdateThreshold(int updateThreshold) {
        this.updateThreshold = updateThreshold;
    }

    public void runOnceInAWhile(Runnable r) {
        if (this.index % this.updateThreshold == 0) {
            r.run();
        }
    }
}

