/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.util;

import fr.obeo.perseus.client.Messages;
import java.time.Duration;

public final class FormattingUtil {
    private FormattingUtil() {
    }

    public static String formatDuration(Duration duration) {
        long s = duration.getSeconds() + (long)(duration.getNano() >= 500000000 ? 1 : 0);
        String result = FormattingUtil.formatSeconds(s);
        return result;
    }

    private static String formatSeconds(long ps) {
        int signum = Long.signum(ps);
        long s = Math.abs(ps);
        String result = s >= 3600L ? String.format(Messages.FormattingUtil_HMMSS, s / 3600L, s % 3600L / 60L, s % 60L) : (s >= 60L ? String.format(Messages.FormattingUtil_MSS, s / 60L, s % 60L) : String.format(Messages.FormattingUtil_S, s % 60L));
        if (signum < 0) {
            result = "-" + result;
        }
        return result;
    }

    public static String formatMillis(Duration duration) {
        return String.format(Messages.FormattingUtil_Sms, FormattingUtil.formatSeconds(duration.getSeconds()), duration.getNano() / 1000000);
    }
}

