/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.util;

import fr.obeo.dsl.traceability.ArtifactType;
import fr.obeo.dsl.traceability.LinkDirection;
import fr.obeo.dsl.traceability.LinkDirectionConstraint;
import fr.obeo.dsl.traceability.LinkRange;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public final class LinkRangeSupport {
    private LinkRangeSupport() {
    }

    public static String humanReadableToTechnicalName(String humanReadable) {
        String result = humanReadable;
        if (humanReadable != null && ("diagram".equalsIgnoreCase(result = humanReadable.replaceAll("\\s", "")) || "ddiagram".equalsIgnoreCase(result))) {
            result = DRepresentationDescriptor.class.getSimpleName();
        }
        return result;
    }

    public static Predicate<LinkRange> isValidForDirection(LinkDirection direction) {
        return linkRange -> LinkRangeSupport.isValidLinkDirection(direction, linkRange.getDirectionConstraint());
    }

    public static Predicate<LinkRange> isValidForAnyTypeIn(Set<String> artifactTypeURIs) {
        return linkRange -> linkRange.getArtifactRange().stream().map(ArtifactType::getUri).anyMatch(uri -> artifactTypeURIs.contains(uri));
    }

    public static Predicate<LinkRange> isValidForTarget(EObject modelObject) {
        return linkRange -> linkRange.getLocalRange().stream().map(LinkRangeSupport::humanReadableToTechnicalName).anyMatch(eClassName -> {
            EClass eClass = modelObject.eClass();
            return eClassName.equalsIgnoreCase(eClass.getName()) || eClass.getEAllSuperTypes().stream().anyMatch(superClass -> eClassName.equalsIgnoreCase(superClass.getName()));
        });
    }

    public static boolean isValidLinkDirection(LinkDirection linkDirection, LinkDirectionConstraint csLinkDirection) {
        boolean isSameLinkDirection = false;
        if (linkDirection != null && csLinkDirection != null && (LinkDirectionConstraint.BOTH.equals((Object)csLinkDirection) || linkDirection.getValue() == csLinkDirection.getValue())) {
            isSameLinkDirection = true;
        }
        return isSameLinkDirection;
    }
}

