/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.emf.common.util.URI;

public final class ModelURI {
    private final URI uri;

    private ModelURI(URI uri) {
        this.uri = Objects.requireNonNull(uri);
        List segments = uri.segmentsList();
        int size = segments.size();
        if (size < 4) {
            throw new IllegalArgumentException();
        }
        try {
            Long.valueOf((String)segments.get(size - 1));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(nfe);
        }
        if (uri.scheme() == null || !uri.scheme().startsWith("http")) {
            throw new IllegalArgumentException();
        }
    }

    public static ModelURI of(URI uri) throws IllegalArgumentException {
        return new ModelURI(uri);
    }

    public static ModelURI of(URI serverURI, UUID projectID, long modelID) throws IllegalArgumentException {
        URI uri = URI.createURI((String)String.format("/projects/%s/edit/%d", projectID, modelID));
        return new ModelURI(uri.resolve(serverURI));
    }

    public static ModelURI of(String uri) throws IllegalArgumentException {
        return new ModelURI(URI.createURI((String)uri));
    }

    public long getModelId() {
        List segments = this.uri.segmentsList();
        int size = segments.size();
        return Long.valueOf((String)segments.get(size - 1));
    }

    public String getProjectId() {
        List segments = this.uri.segmentsList();
        int size = segments.size();
        return (String)segments.get(size - 3);
    }

    public URI getServerURI() {
        return this.uri.trimSegments(Integer.MAX_VALUE);
    }

    public URI getURI() {
        return this.uri;
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.uri.toString());
    }

    public URL getObjectOslcURL(String objectID) throws MalformedURLException {
        return new URL(URI.createURI((String)String.format("../../../oslc/model/%s/%d/%s", this.getProjectId(), this.getModelId(), objectID)).resolve(this.uri).toString());
    }

    public URL getObjectSourceURL(String objectID) throws MalformedURLException {
        return new URL(URI.createURI((String)String.format("./%d-%s", this.getModelId(), objectID)).resolve(this.uri).toString());
    }

    public String toString() {
        return this.uri.toString();
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null) {
            result = false;
        } else if (this.getClass() != obj.getClass()) {
            result = false;
        } else {
            ModelURI other = (ModelURI)obj;
            result = Objects.equals(this.uri, other.uri);
        }
        return result;
    }
}

