/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class MonitorableOutputStream
extends FilterOutputStream {
    private final IProgressMonitor monitor;
    private long transferred = 0L;
    private int progress = 0;
    private long modulo;

    public MonitorableOutputStream(OutputStream out, IProgressMonitor monitor, long totalBytes) {
        super(out);
        this.modulo = Math.max(totalBytes / 1000L, 1L);
        this.monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.transferred += (long)len;
        if (this.transferred / this.modulo > (long)this.progress / this.modulo) {
            int prog = (int)(this.transferred / this.modulo - (long)this.progress / this.modulo);
            this.monitor.worked(prog);
            this.progress += prog;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.transferred;
        if (this.transferred % this.modulo == 0L) {
            this.monitor.worked(1);
            ++this.progress;
        }
    }
}

