/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.util;

import fr.obeo.dsl.traceability.UriPrefix;
import fr.obeo.dsl.traceability.api.INamespaceHelper;
import fr.obeo.perseus.client.dto.PName;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class NamespaceHelper
implements INamespaceHelper {
    private static final String AUTOMATIC_PREFIX = "p_";
    private final Map<String, String> preferredPrefixesByURI;
    private final Map<String, String> prefixesByURI;
    private final Map<String, String> urisByPrefix;
    private int prefixIndex;

    public NamespaceHelper(Map<String, String> preferredPrefixesToURI) {
        LinkedHashMap index = new LinkedHashMap();
        preferredPrefixesToURI.forEach((prefix, uri) -> index.putIfAbsent(uri, prefix));
        this.preferredPrefixesByURI = Collections.unmodifiableMap(index);
        this.prefixesByURI = new LinkedHashMap<String, String>();
        this.urisByPrefix = new LinkedHashMap<String, String>();
    }

    public NamespaceHelper(Collection<UriPrefix> prefixes) {
        LinkedHashMap index = new LinkedHashMap();
        prefixes.forEach(prefix -> index.putIfAbsent(prefix.getKey(), prefix.getValue()));
        this.preferredPrefixesByURI = Collections.unmodifiableMap(index);
        this.prefixesByURI = new LinkedHashMap<String, String>();
        this.urisByPrefix = new LinkedHashMap<String, String>();
    }

    public String asPrefixedName(String nsURI, String name) {
        PName result = this.asPName(nsURI, name);
        return result.toString();
    }

    public PName asPName(String nsURI, String name) {
        String prefix = this.prefixesByURI.computeIfAbsent(nsURI, uri -> {
            String result;
            if (this.preferredPrefixesByURI.containsKey(uri)) {
                result = this.preferredPrefixesByURI.get(uri);
            } else {
                while (this.urisByPrefix.containsKey(result = AUTOMATIC_PREFIX + this.prefixIndex++)) {
                }
            }
            this.urisByPrefix.put(result, (String)uri);
            return result;
        });
        PName result = PName.of(prefix, name);
        return result;
    }

    public Map<String, String> extractPrefixes(Iterable<PName> pNames) throws IllegalArgumentException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (PName pName : pNames) {
            String prefix = pName.getPrefix();
            if (this.urisByPrefix.containsKey(prefix)) {
                result.putIfAbsent(prefix, this.urisByPrefix.get(prefix));
                continue;
            }
            throw new IllegalArgumentException("Prefix '%s' is not registered.");
        }
        return result;
    }

    public Optional<String> getURI(String prefix) {
        return Optional.ofNullable(this.urisByPrefix.get(prefix));
    }

    public Optional<String> getPrefix(String uriString) {
        return Optional.ofNullable(this.prefixesByURI.get(uriString));
    }

    public Set<String> knownPrefixes() {
        return this.urisByPrefix.keySet();
    }

    public Set<String> knownURIs() {
        return this.prefixesByURI.keySet();
    }

    public Map<String, String> getKnownURIsByPrefix() {
        return Collections.unmodifiableMap(this.urisByPrefix);
    }

    public final Map<String, String> getPreferredPrefixesByURI() {
        return this.preferredPrefixesByURI;
    }
}

