/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import fr.obeo.perseus.client.Messages;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.PageInfo;
import fr.obeo.perseus.client.api.PerseusAuthException;
import fr.obeo.perseus.client.api.PerseusCredentialsException;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.impl.InstantDeserializer;
import fr.obeo.perseus.client.impl.PageInfoDeserializer;
import fr.obeo.perseus.client.impl.oauth.OAuthCredentials;
import fr.obeo.perseus.client.util.MonitoredEntityWrapper;
import fr.obeo.perseus.client.util.PerseusProperties;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;

public class PerseusHttpSupport
implements Closeable {
    private static final byte[] PKCE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~".getBytes();
    private static final String ERRORS = "errors";
    private static final String MESSAGE = "message";
    private static final SecureRandom RANDOM = new SecureRandom();
    private final HttpClientConnectionManager connectionManager;
    private final IPerseusServerConfig config;
    private CloseableHttpClient httpClient;

    protected PerseusHttpSupport(HttpClientConnectionManager connectionManager, IPerseusServerConfig config) {
        this.connectionManager = Objects.requireNonNull(connectionManager);
        this.config = config;
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
            this.httpClient = null;
        }
    }

    protected HttpClientBuilder createHttpClientBuilder(IProgressMonitor monitor) throws PerseusCredentialsException, IOException {
        HttpClientBuilder result = null;
        try {
            switch (this.config.getAuthMode()) {
                case LOGIN: {
                    result = this.createLoginHttpClientBuilder();
                    break;
                }
                case OAUTH2: {
                    result = this.createOAuth2HttpClientBuilder(monitor);
                    break;
                }
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        return result;
    }

    protected HttpClientBuilder createOAuth2HttpClientBuilder(IProgressMonitor monitor) throws IOException {
        HttpClientBuilder result = HttpClients.custom().setConnectionManager(this.connectionManager).useSystemProperties().setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultClientConnectionReuseStrategy.INSTANCE);
        OAuthCredentials oauth2Credentials = PerseusClientPlugin.getPlugin().getPerseusServerCredentialProvider().getCredentials(this.config, monitor);
        result.addInterceptorFirst((HttpRequestInterceptor)oauth2Credentials);
        result.addInterceptorFirst((HttpResponseInterceptor)oauth2Credentials);
        return result;
    }

    protected HttpClientBuilder createLoginHttpClientBuilder() throws GeneralSecurityException, PerseusCredentialsException {
        SSLContext context = SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustSelfSignedStrategy.INSTANCE).build();
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)PerseusHttpSupport.getSSLConnectionSocketFactory(context)).build();
        PoolingHttpClientConnectionManager loginConnectionMgr = new PoolingHttpClientConnectionManager(registry);
        Credentials credentials = this.config.getCredentialsProvider().getCredentials(new AuthScope(null, -1));
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("x-perseus-client", "true"));
        if (credentials instanceof UsernamePasswordCredentials) {
            String toEncode = String.valueOf(((UsernamePasswordCredentials)credentials).getUserName()) + ":" + ((UsernamePasswordCredentials)credentials).getPassword();
            headers.add(new BasicHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(toEncode.getBytes())));
            toEncode = null;
        }
        HttpClientBuilder result = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)loginConnectionMgr).useSystemProperties().setConnectionReuseStrategy((ConnectionReuseStrategy)NoConnectionReuseStrategy.INSTANCE).setDefaultHeaders(headers).setDefaultCredentialsProvider(this.config.getCredentialsProvider());
        return result;
    }

    private static SSLConnectionSocketFactory getSSLConnectionSocketFactory(SSLContext context) {
        if (PerseusProperties.isTrustSSLHostname()) {
            return new SSLConnectionSocketFactory(context, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        return new SSLConnectionSocketFactory(context);
    }

    protected CloseableHttpClient getHttpClient(IProgressMonitor monitor) throws IOException, PerseusCredentialsException {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClientBuilder(monitor).build();
        }
        return this.httpClient;
    }

    public static StringEntity createStringEntity(Object o) throws IOException, PerseusServerException {
        ObjectMapper mapper = PerseusHttpSupport.createObjectMapper();
        ObjectWriter writer = mapper.writerFor(o.getClass()).with(SerializationFeature.INDENT_OUTPUT);
        StringWriter sw = new StringWriter();
        writer.writeValue((Writer)sw, o);
        StringEntity entity = new StringEntity(sw.toString(), ContentType.create((String)"application/json", (String)StandardCharsets.UTF_8.name()));
        return entity;
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializer());
        module.addDeserializer(PageInfo.class, (JsonDeserializer)new PageInfoDeserializer());
        mapper.registerModule((Module)module);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        if (PerseusProperties.isDebug()) {
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        return mapper;
    }

    public JsonNode uploadStream(java.net.URI uri, InputStream inputStream, String fileName, IProgressMonitor monitor) throws PerseusServerException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addBinaryBody("file", inputStream, ContentType.APPLICATION_OCTET_STREAM, fileName);
        HttpEntity multipart = builder.build();
        SubMonitor loginMonitor = progress.split(10);
        return this.postHttpEntity(uri, (HttpEntity)new MonitoredEntityWrapper(multipart, (IProgressMonitor)progress.split(90)), (IProgressMonitor)loginMonitor);
    }

    public JsonNode postHttpEntity(java.net.URI uri, HttpEntity entity, IProgressMonitor monitor) throws PerseusServerException {
        HttpPost post = new HttpPost(uri);
        post.setEntity(entity);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableHttpResponse response = this.getHttpClient(monitor).execute((HttpUriRequest)post);){
                if (PerseusHttpSupport.isSuccess((HttpResponse)response)) {
                    return this.handleSuccess(response);
                }
                return this.handleError(response);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new PerseusServerException(e);
        }
    }

    public static boolean isSuccess(HttpResponse response) {
        return response.getStatusLine() != null && response.getStatusLine().getStatusCode() / 100 == 2;
    }

    protected JsonNode handleError(CloseableHttpResponse response) throws PerseusServerException, PerseusCredentialsException {
        int status = Optional.ofNullable(response.getStatusLine()).map(StatusLine::getStatusCode).orElse(-1);
        HttpEntity resp = response.getEntity();
        if (status == 401) {
            throw new PerseusCredentialsException(String.format(Messages.HttpUtil_CheckCredentials, status, "Unauthorized"), this.config);
        }
        String body = Messages.HttpUtil_NoMsg;
        if (resp != null) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream instream = resp.getContent();){
                    StringWriter w = new StringWriter();
                    IOUtils.copy((InputStream)instream, (Writer)w, (String)StandardCharsets.UTF_8.name());
                    body = w.toString();
                    ObjectMapper mapper = PerseusHttpSupport.createObjectMapper();
                    try {
                        JsonNode node = mapper.readTree(body);
                        if (node != null && node.get("error") != null && node.get(MESSAGE) != null) {
                            String error = node.get("error").asText();
                            String msg = node.get(MESSAGE).asText();
                            body = String.format("%s - %s", error, msg);
                        }
                    }
                    catch (JsonParseException jsonParseException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                PerseusClientPlugin.getPlugin().logError(String.format("Problem reading the %d response body.", status), e);
            }
        }
        throw new PerseusServerException(status, String.format(Messages.HttpUtil_errorResponse, status, body));
    }

    protected JsonNode handleSuccess(CloseableHttpResponse response) throws IOException, PerseusServerException, PerseusAuthException {
        int status = response.getStatusLine().getStatusCode();
        HttpEntity resp = response.getEntity();
        if (resp != null) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream instream = resp.getContent();){
                    StringWriter w = new StringWriter();
                    IOUtils.copy((InputStream)instream, (Writer)w, (String)StandardCharsets.UTF_8.name());
                    ObjectMapper mapper = PerseusHttpSupport.createObjectMapper();
                    JsonNode node = mapper.readTree(w.toString());
                    if (node == null) {
                        throw new PerseusServerException(Messages.HttpUtil_emptyResponse);
                    }
                    if (node.get(ERRORS) != null && node.get(ERRORS).isArray()) {
                        String msg = Optional.ofNullable(node.get(ERRORS).findValue(MESSAGE)).map(n -> n.asText()).orElse("");
                        Iterator it = node.get(ERRORS).elements();
                        while (it.hasNext()) {
                            JsonNode nextError = (JsonNode)it.next();
                            JsonNode extensions = nextError.get("extensions");
                            if (extensions != null && extensions.findValue("oauth.authorizationURL") != null) {
                                String authUrl = extensions.findValue("oauth.authorizationURL").asText();
                                throw new PerseusAuthException(msg, authUrl);
                            }
                            if (extensions != null && extensions.findValue("auth.realm") != null) {
                                String friendKey = extensions.findValue("friend.key").asText();
                                String authRealm = extensions.findValue("auth.realm").asText();
                                String authURL = this.config.getApiURI().resolve(String.format("../user/settings/friend/credentials?f=%s&r=%s", URI.encodeQuery((String)friendKey, (boolean)false), URI.encodeQuery((String)authRealm, (boolean)false))).toString();
                                throw new PerseusAuthException(msg, authURL);
                            }
                            if (extensions == null || extensions.findValue("auth.hostName") == null) continue;
                            String friendKey = extensions.findValue("friend.key").asText();
                            String authRealm = extensions.findValue("auth.hostName").asText();
                            String authURL = this.config.getApiURI().resolve(String.format("../user/settings/friend/apikey?f=%s&h=%s", URI.encodeQuery((String)friendKey, (boolean)false), URI.encodeQuery((String)authRealm, (boolean)false))).toString();
                            throw new PerseusAuthException(msg, authURL);
                        }
                        throw new PerseusServerException(msg);
                    }
                    if (PerseusProperties.isDebug()) {
                        try {
                            PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", "DEBUG - JSON payload received from server:\n" + mapper.writeValueAsString((Object)node)));
                        }
                        catch (Exception e) {
                            PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", "DEBUG - Exception trying to log the JSON payload in debug.", (Throwable)e));
                        }
                    }
                    return node;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new PerseusServerException(status, String.format(Messages.HttpUtil_invalidResponse, status), e);
            }
        }
        throw new PerseusServerException(status, String.format(Messages.HttpUtil_missingResponse, status));
    }

    public void checkGraphQLSuccess(JsonNode node, String expectedTypeName) throws PerseusServerException {
        JsonNode typeNameNode = node.findPath("__typename");
        if (typeNameNode != null) {
            JsonNode message;
            String typeName = typeNameNode.asText();
            if (typeName.equals(expectedTypeName)) {
                return;
            }
            if ("ErrorPayload".equals(typeName) && (message = node.findPath(MESSAGE)) != null) {
                throw new PerseusServerException(message.asText());
            }
        }
        throw new PerseusServerException(String.format(Messages.HttpUtil_ErrUnexpectedData, new Object[0]));
    }

    public static String base64UrlEncodeForOAuth2(byte[] bytes) {
        return Base64.getUrlEncoder().encodeToString(bytes).replaceAll("=+$", "");
    }

    public static byte[] pkceCodeVerifier() {
        byte[] result = new byte[64];
        int i = 0;
        while (i < 64) {
            result[i] = PKCE_CHARS[RANDOM.nextInt(66)];
            ++i;
        }
        return result;
    }

    public static class Factory {
        private final SSLContext context = this.createSSLContext();
        private final Registry<ConnectionSocketFactory> registry = this.createConnectionSocketFactoryRegistry();

        public PerseusHttpSupport create(IPerseusServerConfig config) {
            return new PerseusHttpSupport(this.createHttpClientConnectionManager(), config);
        }

        public CloseableHttpClient createDefaultHttpClient() {
            return HttpClients.custom().setConnectionManager(this.createHttpClientConnectionManager()).useSystemProperties().setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultClientConnectionReuseStrategy.INSTANCE).build();
        }

        protected SSLContext createSSLContext() {
            SSLContext ctx;
            try {
                ctx = SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustSelfSignedStrategy.INSTANCE).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
            return ctx;
        }

        protected SSLConnectionSocketFactory getSSLConnectionSocketFactory() {
            if (PerseusProperties.isTrustSSLHostname()) {
                return new SSLConnectionSocketFactory(this.context, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            return new SSLConnectionSocketFactory(this.context);
        }

        protected Registry<ConnectionSocketFactory> createConnectionSocketFactoryRegistry() {
            return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)this.getSSLConnectionSocketFactory()).build();
        }

        protected HttpClientConnectionManager createHttpClientConnectionManager() {
            return new PoolingHttpClientConnectionManager(this.registry);
        }
    }
}

