/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.util;

import fr.obeo.perseus.client.PerseusClientPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class PerseusProperties {
    public static final String PROP_PUBLISH_RESULT_FETCH_INTERVAL = "fr.obeo.perseus.publish.result.fetch.interval.ms";
    private static final int DEFAULT_FETCH_INTERVAL_MS = 5000;
    private static final String PROP_OAUTH2_LOOPBACK_ADDRESS = "fr.obeo.perseus.oauth2.loopback";
    private static final String PROP_OAUTH2_LOCAL_SERVER_PORT = "fr.obeo.perseus.oauth2.local.server.port";
    private static final String PROP_OAUTH2_LOGIN_TIMEOUT = "fr.obeo.perseus.oauth2.login.timeout.ms";
    private static final String PROP_OAUTH2_USE_ID_TOKEN_FOR_ACCESS = "fr.obeo.perseus.oauth2.use.id_token";

    private PerseusProperties() {
    }

    public static boolean isDebug() {
        return Boolean.getBoolean("fr.obeo.perseus.client.debug");
    }

    public static boolean isTrustSSLHostname() {
        return Boolean.getBoolean("fr.obeo.perseus.ssl.trust");
    }

    public static String getOAuth2LoopbackAddress() {
        return System.getProperty(PROP_OAUTH2_LOOPBACK_ADDRESS, "127.0.0.1");
    }

    public static boolean getOAuth2UseIDTokenForAccess() {
        return Boolean.getBoolean(PROP_OAUTH2_USE_ID_TOKEN_FOR_ACCESS);
    }

    public static int getOAuth2LocalServerPort() {
        String s = System.getProperty(PROP_OAUTH2_LOCAL_SERVER_PORT, "-1");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            PerseusClientPlugin.getPlugin().logError(String.format("Invalid value set for System property '%s': '%s' is not an integer. A random port will be used instead.", PROP_OAUTH2_LOCAL_SERVER_PORT, s), e);
            return -1;
        }
    }

    public static int getOAuth2LoginTimeoutMs() {
        int prop = Integer.getInteger(PROP_OAUTH2_LOGIN_TIMEOUT, 10000);
        if (prop < 10) {
            PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client", String.format("Invalid value set for System property '%s': %d is < 10. The timeout will be set to 10ms, although it is recommended to set it to more than 1000 ms.", PROP_OAUTH2_LOGIN_TIMEOUT, prop)));
        }
        return Math.max(prop, 10);
    }

    public static long getPublishResultFetchIntervalMs() {
        long value = 5000L;
        try {
            value = Long.parseLong(System.getProperty(PROP_PUBLISH_RESULT_FETCH_INTERVAL, Integer.toString(5000)));
        }
        catch (NumberFormatException e) {
            PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client", String.format("The system property '%s' has an invalid value (should be an integer), default fetch interval of %d ms. will be used.", PROP_PUBLISH_RESULT_FETCH_INTERVAL, 5000)));
        }
        return value;
    }
}

