/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.util;

import fr.obeo.perseus.client.api.ISessionSupport;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;

public class PerseusSessionUtil
implements ISessionSupport {
    public static final String TRACEABILITY_FILE_EXTENSION = "traceability";

    @Override
    public boolean isOpenSessionFile(IFile iFile) {
        return SessionManager.INSTANCE.getSessions().stream().anyMatch(this.openSessionFile(iFile));
    }

    @Override
    public Optional<Session> findOpenSession(IFile iFile) {
        return SessionManager.INSTANCE.getSessions().stream().filter(this.openSessionFile(iFile)).findFirst();
    }

    @Override
    public Predicate<? super Session> openSessionFile(IFile iFile) {
        return s -> this.isOpenSessionFile(iFile, (Session)s);
    }

    @Override
    public boolean isOpenSessionFile(IFile iFile, Session s) {
        return s.isOpen() && iFile.equals((Object)this.getFile(s.getSessionResource()));
    }

    @Override
    public IFile getFile(Resource r) {
        URI uri = r.getURI();
        if (uri.isPlatformResource()) {
            Path path = new Path(uri.toPlatformString(true));
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }
}

