/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app;

import fr.obeo.ocp.infrastructure.security.SecurityConfiguration;
import fr.obeo.ocp.license.userkey.generator.O;
import fr.obeo.ocp.starter.ObeoCloudPlatformStarterConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.eclipse.sirius.components.collaborative.handlers.GetRepresentationDescriptionEventHandler;
import org.eclipse.sirius.components.core.graphql.datafetchers.EditingContextRepresentationDataFetcher;
import org.eclipse.sirius.web.application.representation.controllers.EditingContextRepresentationsDataFetcher;
import org.eclipse.sirius.web.starter.SiriusWebStarterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication(exclude={SiriusWebStarterConfiguration.class, ObeoCloudPlatformStarterConfiguration.class})
@ConfigurationPropertiesScan(value={"fr.obeo.ocp", "org.eclipse.sirius", "fr.obeo.perseus.server"})
@ComponentScan(basePackages={"fr.obeo.perseus.server", "fr.obeo.ocp.domain", "fr.obeo.ocp.application", "fr.obeo.ocp.infrastructure", "org.eclipse.sirius.components", "org.eclipse.sirius.web.domain", "org.eclipse.sirius.web.application", "org.eclipse.sirius.web.infrastructure", "fr.obeo.ocp.license"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, classes={SecurityConfiguration.class, EditingContextRepresentationsDataFetcher.class, EditingContextRepresentationDataFetcher.class, GetRepresentationDescriptionEventHandler.class})})
public class PerseusServerApplication {
    private static final Logger LOG = LoggerFactory.getLogger(PerseusServerApplication.class);
    private static final String ENVVAR_HTTP_PROXY = "HTTP_PROXY";
    private static final String ENVVAR_HTTPS_PROXY = "HTTPS_PROXY";
    private static final String ENVVAR_NO_PROXY = "NO_PROXY";
    private static final String SYSTEM_HTTP_PROXY_HOST = "http.proxyHost";
    private static final String SYSTEM_HTTP_PROXY_PORT = "http.proxyPort";
    private static final String SYSTEM_HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String SYSTEM_HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String SYSTEM_NON_PROXY_HOSTS = "http.nonProxyHost";

    public static void main(String[] args) {
        SpringApplication.getShutdownHandlers().add(() -> {
            System.out.println("In case of an 'Invalid license' message, please request a license by sending an e-mail to registration@obeo.fr with the following fingerprint:");
            O.main((String[])new String[0]);
        });
        PerseusServerApplication.setSystemPropertiesFromEnv((String)"HTTP_PROXY", (String)"http.proxyHost", (String)"http.proxyPort");
        PerseusServerApplication.setSystemPropertiesFromEnv((String)"HTTPS_PROXY", (String)"https.proxyHost", (String)"https.proxyPort");
        Map<String, String> env = System.getenv();
        String envNoProxy = Optional.ofNullable(env.get("NO_PROXY")).orElseGet(() -> (String)env.get("NO_PROXY".toLowerCase()));
        if (envNoProxy != null && System.getProperty("http.nonProxyHost") == null) {
            System.setProperty("http.nonProxyHost", envNoProxy);
        }
        SpringApplication.run(PerseusServerApplication.class, (String[])args);
    }

    private static void setSystemPropertiesFromEnv(String envVarProp, String sysPropHost, String sysPropPort) {
        Map<String, String> env = System.getenv();
        String envProxy = Optional.ofNullable(env.get(envVarProp)).orElseGet(() -> (String)env.get(envVarProp.toLowerCase()));
        if (envProxy != null && System.getProperty(sysPropHost) == null) {
            try {
                URL httpProxyURL = new URL(envProxy);
                System.setProperty(sysPropHost, httpProxyURL.getHost());
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.format("Setting System property '%s' to value '%s' as defined by environment variable '%s' or '%s'", sysPropHost, envProxy, envVarProp, envVarProp.toLowerCase()));
                }
                if (httpProxyURL.getPort() > 0) {
                    System.setProperty(sysPropPort, Integer.toString(httpProxyURL.getPort()));
                    if (LOG.isInfoEnabled()) {
                        LOG.info(String.format("Setting System property '%s' to value '%s' as defined by environment", sysPropPort, httpProxyURL.getPort()));
                    }
                }
            }
            catch (MalformedURLException e) {
                LOG.error(String.format("The environment variable '%s' (or '%s') is set with an invalid value '%s' that cannot be parsed as a URL", envVarProp, envVarProp.toLowerCase(), envProxy));
            }
        }
    }
}

