/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.auth;

import fr.obeo.perseus.server.common.auth.AuthenticationRequired;
import fr.obeo.perseus.server.common.auth.IAuthenticationRequiredHandlerDelegate;
import fr.obeo.perseus.server.jama.app.graphql.ApiKeyGraphQLError;
import fr.obeo.perseus.server.jama.app.graphql.ApiKeyUserAuthorizationPayload;
import fr.obeo.perseus.server.jama.domain.auth.ApiKeyAuthenticationChallenge;
import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.language.SourceLocation;
import java.util.UUID;
import org.eclipse.sirius.components.core.api.IPayload;
import org.springframework.stereotype.Component;

@Component
public class ApiKeyAuthToPayloadDelegate
implements IAuthenticationRequiredHandlerDelegate {
    public boolean test(AuthenticationRequired t) {
        return t.getChallenge() instanceof ApiKeyAuthenticationChallenge;
    }

    public IPayload toPayload(AuthenticationRequired exception, UUID inputId) {
        ApiKeyAuthenticationChallenge challenge = (ApiKeyAuthenticationChallenge)exception.getChallenge();
        return new ApiKeyUserAuthorizationPayload(inputId, challenge.serverUrl(), exception.getFriend());
    }

    public DataFetcherResult<?> toErrorDataFetcherResult(AuthenticationRequired exception) {
        ApiKeyAuthenticationChallenge challenge = (ApiKeyAuthenticationChallenge)exception.getChallenge();
        return DataFetcherResult.newResult().error((GraphQLError)new ApiKeyGraphQLError(challenge.message(), exception.getFriend().key(), challenge.serverUrl(), new SourceLocation(0, 0))).build();
    }
}

