/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.auth;

import fr.obeo.ocp.domain.boundedcontexts.account.services.api.IAccountSearchService;
import fr.obeo.perseus.server.app.auth.PerseusJwtAuthenticationToken;
import fr.obeo.perseus.server.app.auth.PerseusJwtUser;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.util.Assert;

public class PerseusJwtAuthenticationConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private static final Logger LOG = LoggerFactory.getLogger(PerseusJwtAuthenticationConverter.class);
    private static final String CLAIM_AUTHORIZED_PARTY = "azp";
    private static final String DEFAULT_REGISTRATION_CLIENT_KEY = "keycloak";
    private static final String PROP_JWT_CLIENT_ID_CLAIM = "perseus.oauth2.jwt.client.id.claim";
    private static final String REGISTRATION_ID_PROP_PREFIX = "perseus.oauth2.registration.id.for.";
    private Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();
    private String principalClaimName = "sub";
    private final IAccountSearchService accountSearchService;
    private final Environment environment;

    public PerseusJwtAuthenticationConverter(IAccountSearchService accountSearchService, Environment environment) {
        this.accountSearchService = Objects.requireNonNull(accountSearchService);
        this.environment = Objects.requireNonNull(environment);
    }

    public final AbstractAuthenticationToken convert(Jwt jwt) {
        Collection authorities = (Collection)this.jwtGrantedAuthoritiesConverter.convert((Object)jwt);
        String principalClaimValue = jwt.getClaimAsString(this.principalClaimName);
        String clientIdClaim = this.environment.getProperty(PROP_JWT_CLIENT_ID_CLAIM, CLAIM_AUTHORIZED_PARTY);
        String clientId = jwt.getClaimAsString(clientIdClaim);
        if (clientId == null && jwt.getAudience() != null) {
            clientId = (String)jwt.getAudience().get(0);
        }
        String prop = REGISTRATION_ID_PROP_PREFIX + clientId;
        String registrationId = Optional.ofNullable(this.environment.getProperty(prop)).orElseGet(() -> {
            LOG.error(String.format("The configuration of the server is missing an entry for property '%s'. The default value '%s' will be used.", prop, DEFAULT_REGISTRATION_CLIENT_KEY));
            return DEFAULT_REGISTRATION_CLIENT_KEY;
        });
        PerseusJwtAuthenticationToken token = this.accountSearchService.findByOauth2Id(registrationId, principalClaimValue).map(account -> new PerseusJwtAuthenticationToken(jwt, new PerseusJwtUser(account.getId(), account.getUsername()), authorities)).orElseGet(() -> {
            LOG.warn(String.format("Account with oauth2 ID '%s' not found with registrationId '%s'.\nEven though the user has been authenticated by the authentication server, authentication cannot be granted.\nIt is possible that the user is attempting a connection from the contributor-client without having ever connected to the website.\nUsers must connect at least once to the website so their account gets created before they can be authenticated from the contributor-client.\n", principalClaimValue, registrationId));
            return new PerseusJwtAuthenticationToken(jwt, authorities);
        });
        return token;
    }

    public void setJwtGrantedAuthoritiesConverter(Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter) {
        this.jwtGrantedAuthoritiesConverter = Objects.requireNonNull(jwtGrantedAuthoritiesConverter);
    }

    public void setPrincipalClaimName(String principalClaimName) {
        Assert.hasText((String)principalClaimName, (String)"principalClaimName cannot be empty");
        this.principalClaimName = principalClaimName;
    }
}

