/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.auth;

import fr.obeo.ocp.domain.boundedcontexts.account.services.api.IAccountSearchService;
import fr.obeo.perseus.server.app.auth.PerseusBearerUser;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.NimbusOpaqueTokenIntrospector;

public class PerseusOpaqueTokenIntrospector
extends NimbusOpaqueTokenIntrospector {
    private static final Logger LOG = LoggerFactory.getLogger(PerseusOpaqueTokenIntrospector.class);
    private final IAccountSearchService accountSearchService;
    private final Clock clock;

    public PerseusOpaqueTokenIntrospector(String introspectionUri, String clientId, String clientSecret, IAccountSearchService accountSearchService, Clock clock) {
        super(introspectionUri, clientId, clientSecret);
        this.accountSearchService = Objects.requireNonNull(accountSearchService);
        this.clock = Objects.requireNonNull(clock);
    }

    public OAuth2AuthenticatedPrincipal introspect(String token) {
        OAuth2AuthenticatedPrincipal delegate;
        Instant start = Instant.now(this.clock);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking opaque access token.");
        }
        try {
            delegate = super.introspect(token);
        }
        catch (RuntimeException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Checking opaque access token - Access Token rejected in %s, causing %s with message: %s.", Duration.between(start, Instant.now(this.clock)), e.getClass().getSimpleName(), e.getMessage()));
            }
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Checking opaque access token - Introspect via the ID Provider's introspection endpoint done in %s.", Duration.between(start, Instant.now(this.clock))));
            start = Instant.now(this.clock);
        }
        OAuth2AuthenticatedPrincipal principal = this.accountSearchService.findByOauth2Id("keycloak", delegate.getName()).map(account -> new PerseusBearerUser(account.getId(), account.getUsername(), delegate)).orElseGet(() -> {
            LOG.warn(String.format("Account with oauth2 ID '%s' not found with registrationId '%s'.\nEven though the user has been authenticated by the authentication server, authentication cannot be granted.\nIt is possible that the user is attempting a connection from the contributor-client without having ever connected to the website.\nUsers must connect at least once to the website so their account gets created before they can be authenticated from the contributor-client.\n", delegate.getName(), "keycloak"));
            return delegate;
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Checking opaque access token - Local account matching the opaque access token credentials done in %s.", Duration.between(start, Instant.now(this.clock))));
        }
        return principal;
    }
}

