/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.config;

import fr.obeo.ocp.application.initialization.api.IOCPPermissionEvaluator;
import fr.obeo.ocp.domain.boundedcontexts.account.services.api.IAccountSearchService;
import fr.obeo.ocp.infrastructure.security.HttpCookieOAuth2AuthorizationRequestRepository;
import fr.obeo.ocp.infrastructure.security.OAuth2AuthenticationFailureHandler;
import fr.obeo.ocp.infrastructure.security.OAuth2AuthenticationSuccessHandler;
import fr.obeo.ocp.infrastructure.security.OCPOidcUserService;
import fr.obeo.ocp.license.validator.api.OoOoOoOoOoOo;
import fr.obeo.perseus.server.app.auth.PerseusJwtAuthenticationConverter;
import fr.obeo.perseus.server.app.auth.PerseusOpaqueTokenIntrospector;
import fr.obeo.perseus.server.app.graphql.GraphQLAuthenticationEntryPoint;
import fr.obeo.perseus.server.oauth.config.OauthProperties;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Clock;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.oauth.OAuthMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.web.util.UrlPathHelper;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity(prePostEnabled=true, securedEnabled=true, jsr250Enabled=true)
public class PerseusSecurityConfig {
    public static final String API_SIGNOFF = "/api/signoff";
    public static final String API_AUTHENTICATE = "/api/authenticate";
    public static final String PERSEUS_OCP_LOGIN = "/login";
    public static final String PERSEUS_CLIENT_HEADER = "x-perseus-client";
    private static final Logger LOG = LoggerFactory.getLogger(PerseusSecurityConfig.class);
    private final OoOoOoOoOoOo o;
    @Value(value="${obeo.studio.csrf.enabled:false}")
    private boolean enableCsrf;
    @Value(value="${spring.profiles.active:}")
    private String activeProfiles;
    private final HttpCookieOAuth2AuthorizationRequestRepository httpCookieOAuth2AuthorizationRequestRepository;
    private final OCPOidcUserService ocpOicdUserService;
    private final OAuth2AuthenticationSuccessHandler oAuth2AuthenticationSuccessHandler;
    private final OAuth2AuthenticationFailureHandler oAuth2AuthenticationFailureHandler;
    private final Filter oauthCredentialsFilter;
    private final OauthProperties oauthProps;
    private final HeaderWriter cspHeaderWriter;
    private final GraphQLAuthenticationEntryPoint authEntryPoint;
    private final IAccountSearchService accountSearchService;
    private final Environment environment;

    public PerseusSecurityConfig(HttpCookieOAuth2AuthorizationRequestRepository httpCookieOAuth2AuthorizationRequestRepository, OCPOidcUserService ocpOicdUserService, OAuth2AuthenticationSuccessHandler oAuth2AuthenticationSuccessHandler, OAuth2AuthenticationFailureHandler oAuth2AuthenticationFailureHandler, OoOoOoOoOoOo o, IAccountSearchService accountSearchService, OauthProperties oauthProps, Filter oauthCredentialsFilter, HeaderWriter cspHeaderWriter, GraphQLAuthenticationEntryPoint authEntryPoint, Environment environment) {
        this.httpCookieOAuth2AuthorizationRequestRepository = Objects.requireNonNull(httpCookieOAuth2AuthorizationRequestRepository);
        this.ocpOicdUserService = Objects.requireNonNull(ocpOicdUserService);
        this.oAuth2AuthenticationSuccessHandler = Objects.requireNonNull(oAuth2AuthenticationSuccessHandler);
        this.oAuth2AuthenticationFailureHandler = Objects.requireNonNull(oAuth2AuthenticationFailureHandler);
        this.o = Objects.requireNonNull(o);
        this.oauthProps = Objects.requireNonNull(oauthProps);
        this.cspHeaderWriter = Objects.requireNonNull(cspHeaderWriter);
        this.oauthCredentialsFilter = Objects.requireNonNull(oauthCredentialsFilter);
        this.authEntryPoint = Objects.requireNonNull(authEntryPoint);
        this.accountSearchService = Objects.requireNonNull(accountSearchService);
        this.environment = Objects.requireNonNull(environment);
    }

    @Bean
    public MethodSecurityExpressionHandler methodSecurityExpressionHandler(IOCPPermissionEvaluator permissionEvaluator) {
        DefaultMethodSecurityExpressionHandler expressionHandler = new DefaultMethodSecurityExpressionHandler();
        expressionHandler.setPermissionEvaluator((PermissionEvaluator)permissionEvaluator);
        return expressionHandler;
    }

    @Bean
    SessionAuthenticationStrategy sessionAuthenticationStrategy() {
        return new NullAuthenticatedSessionStrategy();
    }

    @Bean
    @Order(value=5)
    SecurityFilterChain perseusClientSecurityFilterChain(HttpSecurity http) throws Exception {
        http.securityMatcher(req -> {
            if (req.getRequestURI().startsWith("/api/graphql") || req.getRequestURI().startsWith("/api/transaction") || req.getRequestURI().startsWith("/oslc/model/")) {
                String h = req.getHeader(PERSEUS_CLIENT_HEADER);
                boolean result = h != null && Boolean.parseBoolean(h);
                return result;
            }
            return false;
        }).authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.anyRequest()).permitAll()).httpBasic(conf -> conf.authenticationEntryPoint((AuthenticationEntryPoint)this.authEntryPoint));
        http.cors(AbstractHttpConfigurer::disable);
        http.csrf(AbstractHttpConfigurer::disable);
        if (!Arrays.asList(this.activeProfiles.split(",")).contains("dev")) {
            http.requiresChannel(channel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channel.anyRequest()).requiresSecure());
        }
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.security.oauth2.resourceserver.opaquetoken", name={"introspection-uri"})
    OpaqueTokenIntrospector introspector(@Value(value="${spring.security.oauth2.resourceserver.opaquetoken.introspection-uri}") String introspectionUri, @Value(value="${spring.security.oauth2.resourceserver.opaquetoken.client-id}") String clientId, @Value(value="${spring.security.oauth2.resourceserver.opaquetoken.client-secret}") String clientSecret, Clock clock) {
        return new PerseusOpaqueTokenIntrospector(introspectionUri, clientId, clientSecret, this.accountSearchService, clock);
    }

    @Bean
    SecurityFilterChain filterChain(HttpSecurity http, @Value(value="${management.endpoints.web.base-path:/actuator}") String actuatorBasePath) throws Exception {
        http.cors(Customizer.withDefaults());
        if (this.enableCsrf) {
            this.activateCsrf(http);
        } else {
            http.csrf(AbstractHttpConfigurer::disable);
        }
        http.csrf(AbstractHttpConfigurer::disable);
        http.headers(headers -> {
            headers.frameOptions(frameOptions -> frameOptions.disable());
            headers.addHeaderWriter(this.cspHeaderWriter);
        });
        http.authorizeHttpRequests(auth -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{API_AUTHENTICATE, "/api/images/**"})).access((AuthorizationManager)this.o);
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/oauth/admin/**", actuatorBasePath, actuatorBasePath + "/**"})).hasRole("Server Admin");
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/api/**", "/subscriptions"})).authenticated();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).access((AuthorizationManager)this.o);
        });
        http.oauth2Login(oAuth2LoginConfigurer -> ((OAuth2LoginConfigurer)oAuth2LoginConfigurer.authorizationEndpoint(authorizationEndpointConfig -> authorizationEndpointConfig.authorizationRequestRepository((AuthorizationRequestRepository)this.httpCookieOAuth2AuthorizationRequestRepository)).userInfoEndpoint(userInfoEndpointConfig -> userInfoEndpointConfig.oidcUserService((OAuth2UserService)this.ocpOicdUserService)).loginPage(PERSEUS_OCP_LOGIN).failureHandler((AuthenticationFailureHandler)this.oAuth2AuthenticationFailureHandler)).successHandler((AuthenticationSuccessHandler)this.oAuth2AuthenticationSuccessHandler));
        if (this.environment.getProperty("spring.security.oauth2.resourceserver.jwt.issuer-uri") != null) {
            http.oauth2ResourceServer(resourceServerConfigurer -> resourceServerConfigurer.jwt(jwt -> jwt.jwtAuthenticationConverter((Converter)new PerseusJwtAuthenticationConverter(this.accountSearchService, this.environment))));
            if (this.environment.getProperty("spring.security.oauth2.resourceserver.opaquetoken.introspection-uri") != null) {
                LOG.error("Configuration is invalid, only one of 'spring.security.oauth2.resourceserver.jwt.issuer-uri' (if access_tokens are JWT) or 'spring.security.oauth2.resourceserver.opaquetoken.introspection-uri' (if access_tokens are opaque) must be set.");
            }
        } else if (this.environment.getProperty("spring.security.oauth2.resourceserver.opaquetoken.introspection-uri") != null) {
            http.oauth2ResourceServer(oauth2 -> oauth2.opaqueToken(Customizer.withDefaults()));
        } else {
            LOG.error("Configuration is incomplete, either 'spring.security.oauth2.resourceserver.jwt.issuer-uri' (if access_tokens are JWT) or 'spring.security.oauth2.resourceserver.opaquetoken.introspection-uri' (if access_tokens are opaque) must be set.");
        }
        http.exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((arg_0, arg_1, arg_2) -> this.commenceAuthentication(arg_0, arg_1, arg_2)).accessDeniedHandler((arg_0, arg_1, arg_2) -> this.handleAccessDenied(arg_0, arg_1, arg_2)));
        this.configureFormLogin(http);
        LogoutSuccessHandler logoutSuccessHandler = (request, response, authentication) -> {
            response.setStatus(HttpStatus.OK.value());
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("%s - Logout", authentication.getName()));
            }
        };
        http.logout(logoutConfigurer -> logoutConfigurer.logoutSuccessHandler(logoutSuccessHandler).logoutUrl("/api/logout"));
        http.addFilterBefore(this.oauthCredentialsFilter, UsernamePasswordAuthenticationFilter.class);
        if (!Arrays.asList(this.activeProfiles.split(",")).contains("dev")) {
            http.requiresChannel(channel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channel.anyRequest()).requiresSecure());
        }
        return (SecurityFilterChain)http.build();
    }

    private void handleAccessDenied(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("AccessDeniedHandler: Status 401 UNAUTHORIZED\\nRequest URI: %s", new UrlPathHelper().getRequestUri(request)));
        }
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
    }

    private void commenceAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        String requestURI;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("AuthenticationEntryPoint: Status 401 UNAUTHORIZED\nRequest URI: %s", new UrlPathHelper().getRequestUri(request)));
        }
        if ((requestURI = request.getRequestURI()).startsWith("/oslc/") || requestURI.startsWith("/projects/search/")) {
            OAuthMessage om = new OAuthMessage(request.getMethod(), request.getRequestURI(), null);
            response.addHeader("WWW-Authenticate", om.getAuthorizationHeader(this.oauthProps.getRealm()));
        }
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
    }

    private void configureFormLogin(HttpSecurity http) throws Exception {
        AuthenticationSuccessHandler authenticationSuccessHandler = (request, response, authentication) -> {
            response.setStatus(HttpStatus.OK.value());
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("%s - Login through form successful", authentication.getName()));
            }
        };
        AuthenticationFailureHandler authenticationFailureHandler = (request, response, exception) -> {
            LOG.warn(String.format("Failed login attempt with username %s", Optional.ofNullable(request.getParameter("username")).map(user -> String.format("'%s'", user)).orElse("not set")));
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
        };
        http.formLogin(formLogin -> ((FormLoginConfigurer)((FormLoginConfigurer)formLogin.loginPage(PERSEUS_OCP_LOGIN).loginProcessingUrl("/api/login")).successHandler(authenticationSuccessHandler)).failureHandler(authenticationFailureHandler));
        http.rememberMe(Customizer.withDefaults());
    }

    private void activateCsrf(HttpSecurity http) throws Exception {
        CsrfTokenRequestAttributeHandler requestHandler = new CsrfTokenRequestAttributeHandler();
        requestHandler.setCsrfRequestAttributeName(null);
        http.csrf(csrf -> csrf.ignoringRequestMatchers(new String[]{"/oauth/request/**", "/oslc/model/**", "/oslc/rootservices", "/oslc/catalog", "/oslc/serviceProviders/**", "/oslc/config/catalog", "/oslc/config/serviceProvider/**", "/oslc/shapes/**", "/projects/search/**"}).csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).csrfTokenRequestHandler((CsrfTokenRequestHandler)requestHandler));
    }
}

