/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.server.app.properties.PropertyMappingsDefinition;
import fr.obeo.perseus.server.common.ComposedUriProvider;
import fr.obeo.perseus.server.common.services.api.IUriProvider;
import fr.obeo.perseus.server.meta.services.api.IMetaclassRegistry;
import fr.obeo.perseus.server.meta.util.MetaclassUriProvider;
import fr.obeo.perseus.server.oslc.util.OslcModelObjectUriProvider;
import fr.obeo.perseus.server.oslc.util.OslcModelUriProvider;
import fr.obeo.perseus.server.oslc.util.OslcProjectUriProvider;
import fr.obeo.perseus.server.util.DiagramUriProvider;
import fr.obeo.perseus.server.util.IconUriProvider;
import fr.obeo.perseus.server.util.ModelObjectMetaclassUriProvider;
import fr.obeo.perseus.server.util.SourceUriProvider;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.sirius.components.collaborative.api.IEditingContextEventProcessorRegistry;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessor;
import org.eclipse.sirius.components.collaborative.api.IRepresentationEventProcessorFluxCustomizer;
import org.eclipse.sirius.components.collaborative.api.ISubscriptionManagerFactory;
import org.eclipse.sirius.components.collaborative.representations.SubscriptionManager;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.graphql.api.IEditingContextDispatcher;
import org.eclipse.sirius.components.graphql.api.IEventProcessorSubscriptionProvider;
import org.eclipse.sirius.components.graphql.api.IExceptionWrapper;
import org.eclipse.sirius.web.domain.services.api.IMessageService;
import org.eclipse.sirius.web.starter.EditingContextDispatcher;
import org.eclipse.sirius.web.starter.ExceptionWrapper;
import org.ehcache.CacheManager;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.web.exchanges.HttpExchangeRepository;
import org.springframework.boot.actuate.web.exchanges.InMemoryHttpExchangeRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.security.concurrent.DelegatingSecurityContextExecutorService;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.web.util.UriBuilderFactory;
import reactor.core.publisher.Flux;

@Configuration
public class PerseusServerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(PerseusServerConfig.class);
    @Autowired
    private Environment env;
    @Value(value="${perseus.http.tracing:}")
    private String httpTracing;
    @Value(value="${perseus.oslc.thread.pool.size:4}")
    private int oslcThreadPoolSize;
    private final List<IRepresentationEventProcessorFluxCustomizer> representationEventProcessorFluxCustomizers;

    public PerseusServerConfig(List<IRepresentationEventProcessorFluxCustomizer> representationEventProcessorFluxCustomizers) {
        this.representationEventProcessorFluxCustomizers = Objects.requireNonNull(representationEventProcessorFluxCustomizers);
    }

    @Bean
    IEventProcessorSubscriptionProvider eventProcessorSubscriptionProvider(IEditingContextEventProcessorRegistry editingContextEventProcessorRegistry) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Flux<IPayload> customizeFlux(String editingContextId, String representationId, IInput input, IRepresentationEventProcessor representationEventProcessor) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Customize flux in editing context %s for representation %s", editingContextId, representationId));
        }
        Flux flux = representationEventProcessor.getOutputEvents(input);
        for (IRepresentationEventProcessorFluxCustomizer representationEventProcessorFluxCustomizer : this.representationEventProcessorFluxCustomizers) {
            if (!representationEventProcessorFluxCustomizer.canHandle(editingContextId, representationId, input, representationEventProcessor)) continue;
            flux = representationEventProcessorFluxCustomizer.customize(editingContextId, representationId, input, representationEventProcessor, flux);
        }
        return flux;
    }

    @Bean
    IEditingContextDispatcher editingContextDispatcher(IEditingContextEventProcessorRegistry editingContextEventProcessorRegistry, IMessageService messageService) {
        return new EditingContextDispatcher(editingContextEventProcessorRegistry, messageService);
    }

    @Bean
    ISubscriptionManagerFactory subscriptionManagerFactory() {
        return SubscriptionManager::new;
    }

    @Bean
    IExceptionWrapper exceptionWrapper() {
        return new ExceptionWrapper();
    }

    @Bean
    @Primary
    Clock clock() {
        return Clock.systemUTC();
    }

    @Bean
    Clock microSecondClock(Clock clock) {
        return Clock.tick(clock, Duration.ofNanos(1000L));
    }

    @Bean
    PropertyMappingsDefinition propertyMappingsDefinition(@Value(value="${perseus.properties.mappings:classpath:prop-mappings.json}") Resource propMappingsResource) {
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Loading Property Mappings from '%s'", propMappingsResource));
            }
            PropertyMappingsDefinition result = (PropertyMappingsDefinition)new ObjectMapper().readerFor(PropertyMappingsDefinition.class).readValue(propMappingsResource.getInputStream());
            return result;
        }
        catch (IOException e) {
            LOG.error(String.format("Property Mappings could not be loaded from '%s': %s", propMappingsResource, e.getMessage()));
            return new PropertyMappingsDefinition();
        }
    }

    @Bean
    CacheManager cacheManager() {
        return CacheManagerBuilder.newCacheManagerBuilder().build(true);
    }

    @Bean
    IUriProvider uriProvider(UriBuilderFactory uriBuilderFactory, IMetaclassRegistry mcRegistry) {
        ComposedUriProvider prov = new ComposedUriProvider();
        return prov.with((IUriProvider)new SourceUriProvider(uriBuilderFactory)).with((IUriProvider)new IconUriProvider(uriBuilderFactory, mcRegistry)).with((IUriProvider)new MetaclassUriProvider(uriBuilderFactory, mcRegistry)).with((IUriProvider)new ModelObjectMetaclassUriProvider(uriBuilderFactory, mcRegistry)).with((IUriProvider)new OslcModelObjectUriProvider(uriBuilderFactory)).with((IUriProvider)new DiagramUriProvider(uriBuilderFactory)).with((IUriProvider)new OslcProjectUriProvider(uriBuilderFactory)).with((IUriProvider)new OslcModelUriProvider(uriBuilderFactory));
    }

    @Bean
    @ConditionalOnProperty(prefix="perseus.http", name={"tracing"}, havingValue="in-memory")
    HttpExchangeRepository httpTraceRepository() {
        return new InMemoryHttpExchangeRepository();
    }

    @Bean
    @Qualifier(value="oslcExecutorService")
    ExecutorService oslcExecutorService() {
        return new DelegatingSecurityContextExecutorService(Executors.newFixedThreadPool(this.oslcThreadPoolSize));
    }

    @Bean
    JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        OidcIdTokenDecoderFactory idTokenDecoderFactory = new OidcIdTokenDecoderFactory();
        idTokenDecoderFactory.setJwsAlgorithmResolver(clientRegistration -> {
            String registrationId = clientRegistration.getRegistrationId();
            String explicitAlgorithmName = this.env.getProperty("perseus.oauth2.signing.algorithm." + registrationId);
            if (explicitAlgorithmName != null) {
                SignatureAlgorithm sigAlg = SignatureAlgorithm.from((String)explicitAlgorithmName);
                if (sigAlg != null) {
                    return sigAlg;
                }
                MacAlgorithm macAlg = MacAlgorithm.from((String)explicitAlgorithmName);
                if (macAlg != null) {
                    return macAlg;
                }
            }
            return SignatureAlgorithm.RS256;
        });
        return idTokenDecoderFactory;
    }
}

