/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.server.app.services.debug.DebugHistoryService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/history"})
@Profile(value={"dev"})
public class DebugHistoryController {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private DebugHistoryService debugHistoryService;

    @GetMapping(path={"/{projectId}/{modelId}/commits"}, produces={"application/json"})
    public void getModelHistory(@PathVariable(value="projectId") String projectId, @PathVariable(value="modelId") long modelId, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map exportModelHistory = this.debugHistoryService.exportModelHistory(projectId, modelId);
        this.objectMapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)resp.getOutputStream(), (Object)exportModelHistory);
    }

    @GetMapping(path={"/{projectId}/{modelId}/commits/{objectId}"}, produces={"application/json"})
    public void getModelObjectHistory(@PathVariable(value="projectId") String projectId, @PathVariable(value="modelId") long modelId, @PathVariable(value="objectId") String objectId, @RequestParam(name="limit", required=true) Integer limit, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.objectMapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)resp.getOutputStream(), (Object)this.debugHistoryService.exportModelObjectHistory(projectId, modelId, objectId, limit));
    }

    @GetMapping(path={"/{projectId}/{modelId}/commit/master/{version}"}, produces={"application/json"})
    public void getMasterCommit(@PathVariable(value="projectId") String projectId, @PathVariable(value="modelId") long modelId, @PathVariable(value="version") int version, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.objectMapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)resp.getOutputStream(), (Object)this.debugHistoryService.exportCommit(projectId, modelId, Optional.empty(), version));
    }
}

