/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.IIcon;
import fr.obeo.perseus.server.services.api.IIconService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(path={"/api/images/icons"})
public class IconController {
    @Autowired
    private IIconService iconService;

    @GetMapping(value={"/{hash}"})
    @PreAuthorize(value="isAuthenticated()")
    public void icon(@PathVariable(value="hash") String iconHash, HttpServletResponse response) throws ServletException, IOException {
        IIcon icon = this.iconService.getIcon(iconHash);
        response.setContentType(icon.getMimeType());
        response.setHeader("Cache-Control", "private");
        response.getOutputStream().write(icon.getData());
        response.getOutputStream().flush();
    }
}

