/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.IImage;
import fr.obeo.perseus.server.ImageID;
import fr.obeo.perseus.server.common.services.api.IProjectAccessLevelService;
import fr.obeo.perseus.server.repositories.IImageRepository;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(path={"/image"})
public class ImageController {
    @Autowired
    private IImageRepository imageRepository;
    @Autowired
    private IProjectAccessLevelService projectAccessLevelService;

    @GetMapping(value={"/{projectId}/{modelUid}/{hash}"})
    @PreAuthorize(value="isAuthenticated()")
    public void image(@PathVariable String projectId, @PathVariable long modelUid, @PathVariable String hash, HttpServletResponse response) throws ServletException, IOException {
        this.projectAccessLevelService.checkAccessLevel(projectId, "READ");
        IImage image = (IImage)this.imageRepository.findById((Object)new ImageID(modelUid, hash)).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        response.setContentType(image.getMimeType());
        response.setHeader("Cache-Control", "private");
        response.getOutputStream().write(image.getData());
        response.getOutputStream().flush();
    }
}

