/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.common.services.api.ICurrentAccountService;
import fr.obeo.perseus.server.jobs.AbstractJobDTO;
import fr.obeo.perseus.server.services.jobs.JobManager;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Objects;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

@QueryDataFetcher(type="Viewer", field="jobs")
public class JobsDataFetcher
implements IDataFetcherWithFieldCoordinates<List<AbstractJobDTO>> {
    public static final String DAYS_ARGUMENT = "days";
    private final JobManager jobManager;
    private final ICurrentAccountService currentAccountService;

    public JobsDataFetcher(JobManager jobManager, ICurrentAccountService currentAccountService) {
        this.jobManager = Objects.requireNonNull(jobManager);
        this.currentAccountService = Objects.requireNonNull(currentAccountService);
    }

    public List<AbstractJobDTO> get(DataFetchingEnvironment environment) throws Exception {
        Object daysArg = environment.getArgument(DAYS_ARGUMENT);
        int days = (Integer)daysArg;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String adminRole = "ROLE_Server Admin";
        boolean isAdministrator = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(adminRole::equals);
        if (isAdministrator) {
            return this.jobManager.getAllJobs(days);
        }
        return this.jobManager.getJobs(days, this.currentAccountService.getCurrentAccountId());
    }
}

