/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.app.services.IEditingContextAwareRepresentationMetadataSearchService;
import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import graphql.validation.ValidationError;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.core.api.IEditingContextSearchService;
import org.eclipse.sirius.components.core.graphql.dto.RepresentationMetadataDTO;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;

@QueryDataFetcher(type="EditingContext", field="representation")
public class PerseusEditingContextRepresentationDataFetcher
implements IDataFetcherWithFieldCoordinates<DataFetcherResult<RepresentationMetadataDTO>> {
    private static final String REPRESENTATION_ID_ARGUMENT = "representationId";
    private final IEditingContextSearchService editingContextSearchService;
    private IEditingContextAwareRepresentationMetadataSearchService editingContextAwareRepresentationMetadataSearchService;

    public PerseusEditingContextRepresentationDataFetcher(IEditingContextSearchService editingContextSearchService, IEditingContextAwareRepresentationMetadataSearchService editingContextAwareRepresentationMetadataSearchService) {
        this.editingContextSearchService = Objects.requireNonNull(editingContextSearchService);
        this.editingContextAwareRepresentationMetadataSearchService = Objects.requireNonNull(editingContextAwareRepresentationMetadataSearchService);
    }

    public DataFetcherResult<RepresentationMetadataDTO> get(DataFetchingEnvironment environment) throws Exception {
        String editingContextId = (String)environment.getSource();
        Optional optEditingContext = this.editingContextSearchService.findById(editingContextId);
        String representationId = (String)environment.getArgument(REPRESENTATION_ID_ARGUMENT);
        HashMap<String, String> localContext = new HashMap<String, String>((Map)environment.getLocalContext());
        localContext.put(REPRESENTATION_ID_ARGUMENT, representationId);
        return optEditingContext.flatMap(editingContext -> this.editingContextAwareRepresentationMetadataSearchService.findRepresentationMetadataById(editingContext, representationId)).map(representationMetadata -> DataFetcherResult.newResult().data(representationMetadata).localContext((Object)localContext).build()).orElseGet(() -> DataFetcherResult.newResult().error((GraphQLError)ValidationError.newValidationError().description(String.format("Representation '%s' not found in editing context '%s'.", representationId, editingContextId)).build()).localContext((Object)localContext).build());
    }
}

