/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.app.services.IEditingContextAwareRepresentationMetadataSearchService;
import graphql.execution.DataFetcherResult;
import graphql.relay.Connection;
import graphql.relay.ConnectionCursor;
import graphql.relay.DefaultConnection;
import graphql.relay.DefaultConnectionCursor;
import graphql.relay.DefaultEdge;
import graphql.relay.Edge;
import graphql.relay.PageInfo;
import graphql.relay.Relay;
import graphql.schema.DataFetchingEnvironment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.core.api.IEditingContext;
import org.eclipse.sirius.components.core.api.IEditingContextSearchService;
import org.eclipse.sirius.components.core.graphql.dto.PageInfoWithCount;
import org.eclipse.sirius.components.core.graphql.dto.RepresentationMetadataDTO;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

@QueryDataFetcher(type="EditingContext", field="representations")
public class PerseusEditingContextRepresentationsDataFetcher
implements IDataFetcherWithFieldCoordinates<Connection<DataFetcherResult<RepresentationMetadataDTO>>> {
    private static final String REPRESENTATION_IDS_ARGUMENT = "representationIds";
    private IEditingContextSearchService editingContextSearchService;
    private IEditingContextAwareRepresentationMetadataSearchService editingContextAwareRepresentationMetadataSearchService;

    public PerseusEditingContextRepresentationsDataFetcher(IEditingContextSearchService editingContextSearchService, IEditingContextAwareRepresentationMetadataSearchService editingContextAwareRepresentationMetadataSearchService) {
        this.editingContextSearchService = Objects.requireNonNull(editingContextSearchService);
        this.editingContextAwareRepresentationMetadataSearchService = Objects.requireNonNull(editingContextAwareRepresentationMetadataSearchService);
    }

    public Connection<DataFetcherResult<RepresentationMetadataDTO>> get(DataFetchingEnvironment environment) throws Exception {
        String editingContextId = (String)environment.getSource();
        Optional optEditingContext = this.editingContextSearchService.findById(editingContextId);
        Page representationMetadataPage = Page.empty();
        List representationIds = (List)environment.getArgument(REPRESENTATION_IDS_ARGUMENT);
        if (representationIds != null && optEditingContext.isPresent()) {
            IEditingContext editingContext = (IEditingContext)optEditingContext.get();
            List allRepresentationMetadata = representationIds.stream().map(rid -> this.editingContextAwareRepresentationMetadataSearchService.findRepresentationMetadataById(editingContext, rid)).flatMap(Optional::stream).toList();
            representationMetadataPage = new PageImpl(allRepresentationMetadata, Pageable.unpaged(), (long)allRepresentationMetadata.size());
        }
        return this.toConnection(environment, representationMetadataPage);
    }

    private Connection<DataFetcherResult<RepresentationMetadataDTO>> toConnection(DataFetchingEnvironment environment, Page<RepresentationMetadataDTO> representationMetadataPage) {
        List<Edge> edges = representationMetadataPage.stream().map(representationMetadata -> {
            String globalId = new Relay().toGlobalId("RepresentationMetadata", representationMetadata.id().toString());
            DefaultConnectionCursor cursor = new DefaultConnectionCursor(globalId);
            HashMap<String, String> localContext = new HashMap<String, String>((Map)environment.getLocalContext());
            localContext.put("representationId", representationMetadata.id().toString());
            return new DefaultEdge((Object)DataFetcherResult.newResult().data(representationMetadata).localContext(localContext).build(), (ConnectionCursor)cursor);
        }).toList();
        ConnectionCursor startCursor = edges.stream().findFirst().map(Edge::getCursor).orElse(null);
        ConnectionCursor endCursor = null;
        if (!edges.isEmpty()) {
            endCursor = edges.get(edges.size() - 1).getCursor();
        }
        PageInfoWithCount pageInfo = new PageInfoWithCount(startCursor, endCursor, representationMetadataPage.hasPrevious(), representationMetadataPage.hasNext(), representationMetadataPage.getTotalElements());
        return new DefaultConnection(edges, (PageInfo)pageInfo);
    }
}

