/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.versioning.IBranch;
import fr.obeo.perseus.server.versioning.repositories.IBranchRepository;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;

@QueryDataFetcher(type="Project", field="branch")
public class ProjectBranchDataFetcher
implements IDataFetcherWithFieldCoordinates<IBranch> {
    private static final String BRANCH_ID_ARGUMENT = "branchId";
    private final IBranchRepository branchRepository;

    public ProjectBranchDataFetcher(IBranchRepository branchRepository) {
        this.branchRepository = Objects.requireNonNull(branchRepository);
    }

    public IBranch get(DataFetchingEnvironment environment) throws Exception {
        String branchId = (String)environment.getArgument(BRANCH_ID_ARGUMENT);
        return this.branchRepository.findById((Object)UUID.fromString(branchId)).orElse(null);
    }
}

