/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.app.data.FullCommitID;
import fr.obeo.perseus.server.app.services.ICommitEditingContextService;
import fr.obeo.perseus.server.versioning.CommitID;
import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.web.application.project.dto.ProjectDTO;

@QueryDataFetcher(type="Project", field="commitEditingContext")
public class ProjectCommitEditingContextDataFetcher
implements IDataFetcherWithFieldCoordinates<DataFetcherResult<String>> {
    private static final String BRANCH_ID = "branchId";
    private static final String VERSION = "version";
    private final ICommitEditingContextService commitEditingContextService;

    public ProjectCommitEditingContextDataFetcher(ICommitEditingContextService commitEditingContextService) {
        this.commitEditingContextService = Objects.requireNonNull(commitEditingContextService);
    }

    public DataFetcherResult<String> get(DataFetchingEnvironment environment) throws Exception {
        ProjectDTO project = (ProjectDTO)environment.getSource();
        UUID branchId = UUID.fromString((String)environment.getArgument(BRANCH_ID));
        int version = (Integer)environment.getArgument(VERSION);
        FullCommitID fullCommitId = new FullCommitID(project.id(), new CommitID(branchId, version));
        return this.commitEditingContextService.getEditingContextId(fullCommitId).map(arg_0 -> this.toDataFetcherResult(arg_0)).orElseGet(() -> DataFetcherResult.newResult().error(GraphQLError.newError().errorType(ErrorClassification.errorClassification((String)"Invalid or forbidden Commit ID")).message("Invalid or forbidden Commit ID.", new Object[0]).build()).build());
    }

    private DataFetcherResult<String> toDataFetcherResult(String editingContextId) {
        HashMap<String, String> localContext = new HashMap<String, String>();
        localContext.put("editingContextId", editingContextId);
        return DataFetcherResult.newResult().data((Object)editingContextId).localContext(localContext).build();
    }
}

