/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import fr.obeo.perseus.server.IModel;
import fr.obeo.perseus.server.dto.model.ModelDTO;
import fr.obeo.perseus.server.repositories.IModelRepository;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.web.application.project.dto.ProjectDTO;

@QueryDataFetcher(type="Project", field="model")
public class ProjectModelDataFetcher
implements IDataFetcherWithFieldCoordinates<ModelDTO> {
    private static final String MODEL_ID_ARGUMENT = "modelId";
    private final IModelRepository modelRepository;

    public ProjectModelDataFetcher(IModelRepository modelRepository) {
        this.modelRepository = Objects.requireNonNull(modelRepository);
    }

    public ModelDTO get(DataFetchingEnvironment environment) throws Exception {
        ProjectDTO project = (ProjectDTO)environment.getSource();
        String projectId = project.id();
        Number modelId = (Number)environment.getArgument(MODEL_ID_ARGUMENT);
        return this.modelRepository.findById((Object)modelId.longValue()).filter(entity -> projectId.equals(entity.getProjectId())).map(arg_0 -> this.toDTO(arg_0)).orElse(null);
    }

    private ModelDTO toDTO(IModel model) {
        ModelDTO result = new ModelDTO();
        result.setName(model.getName());
        result.setId(model.getUid().longValue());
        result.setDescription(model.getDescription());
        result.setIconHash(model.getIconHash());
        return result;
    }
}

