/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.server.services.api.ISearchService;
import fr.obeo.perseus.server.services.api.search.SearchInput;
import fr.obeo.perseus.server.services.api.search.groups.SearchResult;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sirius.components.annotations.spring.graphql.QueryDataFetcher;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.web.application.project.dto.ProjectDTO;

@QueryDataFetcher(type="Project", field="search")
public class ProjectSearchDataFetcher
implements IDataFetcherWithFieldCoordinates<SearchResult> {
    private static final String PAGE_ARGUMENT = "page";
    private static final String LIMIT_ARGUMENT = "limit";
    private final ObjectMapper objectMapper;
    private final ISearchService searchServices;

    public ProjectSearchDataFetcher(ObjectMapper objectMapper, ISearchService searchServices) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.searchServices = Objects.requireNonNull(searchServices);
    }

    public SearchResult get(DataFetchingEnvironment environment) throws Exception {
        int page = this.getPage(environment);
        int limit = this.getLimit(environment);
        ProjectDTO project = (ProjectDTO)environment.getSource();
        String projectId = project.id();
        Object argument = environment.getArgument("searchInput");
        SearchInput input = (SearchInput)this.objectMapper.convertValue(argument, SearchInput.class);
        return this.searchServices.search(projectId, input, page, limit);
    }

    private int getPage(DataFetchingEnvironment environment) {
        return Optional.ofNullable((Integer)environment.getArgument(PAGE_ARGUMENT)).filter(page -> page > 0).orElse(0);
    }

    private int getLimit(DataFetchingEnvironment environment) {
        return Optional.ofNullable((Integer)environment.getArgument(LIMIT_ARGUMENT)).filter(limit -> limit > 0).orElse(20);
    }
}

