/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.editingContext;

import fr.obeo.perseus.server.app.data.CommitEditingContext;
import fr.obeo.perseus.server.app.data.GQLModelObjectRef;
import fr.obeo.perseus.server.common.services.api.ILabelProvider;
import fr.obeo.perseus.server.meta.MetaclassQName;
import fr.obeo.perseus.server.services.api.dto.versioning.ModelObjectSnapshot;
import fr.obeo.perseus.server.services.api.model.versioning.IModelObjectSnapshotSearchService;
import fr.obeo.perseus.server.services.api.modelobject.BasicModelObjectID;
import fr.obeo.perseus.server.services.api.modelobject.IModelObjectID;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CommitModelObjectsDataFetcherDelegate {
    private final IModelObjectSnapshotSearchService modelObjectSnapshotSearchService;
    private final ILabelProvider<ModelObjectSnapshot> modelObjectSnapshotLabelProvider;

    public CommitModelObjectsDataFetcherDelegate(IModelObjectSnapshotSearchService modelObjectSnapshotSearchService, ILabelProvider<ModelObjectSnapshot> modelObjectSnapshotLabelProvider) {
        this.modelObjectSnapshotSearchService = Objects.requireNonNull(modelObjectSnapshotSearchService);
        this.modelObjectSnapshotLabelProvider = Objects.requireNonNull(modelObjectSnapshotLabelProvider);
    }

    public List<GQLModelObjectRef> get(CommitEditingContext editingContext, List<String> uids, Number modelId) {
        List<BasicModelObjectID> objectIds = uids.stream().map(uid -> new BasicModelObjectID(editingContext.getProjectId(), modelId.longValue(), uid)).toList();
        Map snapshots = this.modelObjectSnapshotSearchService.findModelObjectsInCommit(objectIds, editingContext.getCommit());
        ArrayList<GQLModelObjectRef> result = new ArrayList<GQLModelObjectRef>();
        for (Map.Entry entry : snapshots.entrySet()) {
            String reprId;
            IModelObjectID moID = (IModelObjectID)entry.getKey();
            ModelObjectSnapshot mos = (ModelObjectSnapshot)entry.getValue();
            MetaclassQName metaclassQName = mos.getIntrinsic().getMetaclass();
            GQLModelObjectRef.GQLModelObjectRefBuilder builder = GQLModelObjectRef.builder();
            Optional optSemanticTarget = Optional.empty();
            ModelObjectSnapshot snapshotForIcon = mos;
            if (metaclassQName.isRepresentationDescriptor() && (optSemanticTarget = this.modelObjectSnapshotSearchService.findModelObjectInCommit(moID.forObjectInSameModel(reprId = String.valueOf(mos.getIntrinsic().getStructuralFeatureSettings().get("representation"))), editingContext.getCommit())).isPresent()) {
                snapshotForIcon = (ModelObjectSnapshot)optSemanticTarget.get();
            }
            GQLModelObjectRef summary = builder.setObjectId(moID.getObjectId()).setName(this.modelObjectSnapshotLabelProvider.getName((Object)mos)).setType(metaclassQName).setImageURL(this.modelObjectSnapshotLabelProvider.getIconURI((Object)snapshotForIcon).toString()).build();
            result.add(summary);
        }
        return result;
    }
}

