/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.editingContext;

import fr.obeo.perseus.server.IModelObject;
import fr.obeo.perseus.server.ModelObjectID;
import fr.obeo.perseus.server.app.data.GQLModelObjectRef;
import fr.obeo.perseus.server.app.data.ProjectEditingContext;
import fr.obeo.perseus.server.common.services.api.ILabelProvider;
import fr.obeo.perseus.server.dto.meta.MetaclassDTO;
import fr.obeo.perseus.server.meta.MetaclassQName;
import fr.obeo.perseus.server.meta.services.api.IMetaclassRegistry;
import fr.obeo.perseus.server.repositories.IModelObjectRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ProjectBreadcrumbsDataFetcherDelegate {
    private final IModelObjectRepository modelObjectRepo;
    private final IMetaclassRegistry mcRegistry;
    private final ILabelProvider<IModelObject> modelObjectLabelProvider;

    public ProjectBreadcrumbsDataFetcherDelegate(IModelObjectRepository modelObjectRepo, IMetaclassRegistry mcRegistry, ILabelProvider<IModelObject> modelObjectLabelProvider) {
        this.modelObjectRepo = Objects.requireNonNull(modelObjectRepo);
        this.mcRegistry = Objects.requireNonNull(mcRegistry);
        this.modelObjectLabelProvider = Objects.requireNonNull(modelObjectLabelProvider);
    }

    public List<GQLModelObjectRef> get(ProjectEditingContext editingContext, Number modelId, String objectId) {
        Optional modelObjectOpt = this.modelObjectRepo.loadModelObjectSummaryByUid(new ModelObjectID(modelId.longValue(), objectId));
        if (modelObjectOpt.isPresent()) {
            IModelObject parentRow;
            IModelObject mor = (IModelObject)modelObjectOpt.get();
            ArrayList<GQLModelObjectRef> breadCrumbs = new ArrayList<GQLModelObjectRef>();
            String parentUid = mor.getParentUid();
            while (parentUid != null && (parentRow = (IModelObject)this.modelObjectRepo.loadModelObjectSummaryByUid(new ModelObjectID(modelId.longValue(), parentUid)).orElse(null)) != null) {
                long metaclassId = parentRow.getMetaclassUid();
                MetaclassDTO metaclass = this.mcRegistry.getMetaclassByUid(metaclassId).orElseGet(MetaclassDTO::unknown);
                GQLModelObjectRef breadCrumb = GQLModelObjectRef.builder().setObjectId(parentRow.getUid()).setName(this.modelObjectLabelProvider.getName((Object)parentRow)).setType(new MetaclassQName(metaclass.getName(), metaclass.getMetamodelURI().toString())).setImageURL(this.modelObjectLabelProvider.getIconURI((Object)parentRow).toString()).build();
                breadCrumbs.add(0, breadCrumb);
                parentUid = parentRow.getParentUid();
            }
            return breadCrumbs;
        }
        throw new IllegalArgumentException("ModelObject with uid " + objectId + " not found in model " + modelId);
    }
}

