/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.mutation;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.server.services.api.dto.versioning.CreateBaselineInput;
import fr.obeo.perseus.server.services.api.dto.versioning.CreateBaselineSuccessPayload;
import fr.obeo.perseus.server.services.api.model.versioning.IHistoryOfModelSearchService;
import fr.obeo.perseus.server.versioning.CommitID;
import fr.obeo.perseus.server.versioning.IBaseline;
import fr.obeo.perseus.server.versioning.IHistory;
import fr.obeo.perseus.server.versioning.api.IBaselineCreationService;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.sirius.components.annotations.spring.graphql.MutationDataFetcher;
import org.eclipse.sirius.components.core.api.ErrorPayload;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.events.ICause;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.components.graphql.api.IExceptionWrapper;
import org.eclipse.sirius.web.domain.services.Failure;
import org.eclipse.sirius.web.domain.services.IResult;
import org.eclipse.sirius.web.domain.services.Success;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

@MutationDataFetcher(type="Mutation", field="createBaseline")
public class MutationCreateBaselineDataFetcher
implements IDataFetcherWithFieldCoordinates<IPayload> {
    private static final Logger LOG = LoggerFactory.getLogger(MutationCreateBaselineDataFetcher.class);
    private final ObjectMapper objectMapper;
    private final IExceptionWrapper exceptionWrapper;
    private final IHistoryOfModelSearchService historyOfModelSearchService;
    private final IBaselineCreationService baselineCreationService;

    public MutationCreateBaselineDataFetcher(ObjectMapper objectMapper, IExceptionWrapper exceptionWrapper, IHistoryOfModelSearchService historyOfModelSearchService, IBaselineCreationService baselineCreationService) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.exceptionWrapper = Objects.requireNonNull(exceptionWrapper);
        this.historyOfModelSearchService = Objects.requireNonNull(historyOfModelSearchService);
        this.baselineCreationService = Objects.requireNonNull(baselineCreationService);
    }

    public IPayload get(DataFetchingEnvironment environment) throws Exception {
        IPayload payload;
        Object argument = environment.getArgument("input");
        CreateBaselineInput input = (CreateBaselineInput)this.objectMapper.convertValue(argument, CreateBaselineInput.class);
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' to create a new baseline submitted", SecurityContextHolder.getContext().getAuthentication().getName(), input.id()));
        }
        if ((payload = this.exceptionWrapper.wrap(() -> this.createBaseline(input), (IInput)input)) instanceof ErrorPayload) {
            ErrorPayload errorPayload = (ErrorPayload)payload;
            LOG.warn(String.format("%s - Request '%s' to create a new baseline failed: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), errorPayload));
        } else if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' to create a new baseline successful: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), payload));
        }
        return payload;
    }

    private IPayload createBaseline(CreateBaselineInput input) {
        fr.obeo.perseus.server.versioning.api.CreateBaselineInput createTagInput;
        IHistory history = (IHistory)this.historyOfModelSearchService.findModelHistory(input.projectId(), input.modelId()).orElseThrow(() -> new IllegalArgumentException(String.format("Cannot find a History for model with id %d in the project '%s'", input.modelId(), input.projectId())));
        IResult result = this.baselineCreationService.createBaseline(history, createTagInput = fr.obeo.perseus.server.versioning.api.CreateBaselineInput.forId((UUID)input.id()).withTitle(input.title()).withCausedBy((ICause)input).withCommitId(new CommitID(input.branchId(), input.version())).build());
        if (result instanceof Failure) {
            Failure fail = (Failure)result;
            return new ErrorPayload(input.id(), fail.message());
        }
        return new CreateBaselineSuccessPayload(input.id(), (IBaseline)((Success)result).data());
    }
}

