/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.mutation;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.server.services.api.IModelService;
import fr.obeo.perseus.server.services.api.dto.model.graphql.CreateModelInput;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import org.eclipse.sirius.components.annotations.spring.graphql.MutationDataFetcher;
import org.eclipse.sirius.components.core.api.ErrorPayload;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.components.graphql.api.IExceptionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

@MutationDataFetcher(type="Mutation", field="createModel")
public class MutationCreateModelDataFetcher
implements IDataFetcherWithFieldCoordinates<IPayload> {
    private static final Logger LOG = LoggerFactory.getLogger(MutationCreateModelDataFetcher.class);
    private final ObjectMapper objectMapper;
    private final IExceptionWrapper exceptionWrapper;
    private final IModelService modelService;

    public MutationCreateModelDataFetcher(ObjectMapper objectMapper, IExceptionWrapper exceptionWrapper, IModelService modelService) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.exceptionWrapper = Objects.requireNonNull(exceptionWrapper);
        this.modelService = Objects.requireNonNull(modelService);
    }

    public IPayload get(DataFetchingEnvironment environment) throws Exception {
        IPayload payload;
        Object argument = environment.getArgument("input");
        CreateModelInput input = (CreateModelInput)this.objectMapper.convertValue(argument, CreateModelInput.class);
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' to create a new model submitted", SecurityContextHolder.getContext().getAuthentication().getName(), input.id()));
        }
        if ((payload = this.exceptionWrapper.wrap(() -> this.modelService.create(input), (IInput)input)) instanceof ErrorPayload) {
            ErrorPayload errorPayload = (ErrorPayload)payload;
            LOG.warn(String.format("%s - Request '%s' to create a new model failed: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), errorPayload));
        } else if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' to create a new model successful: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), payload));
        }
        return payload;
    }
}

