/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.mutation;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.server.services.api.ITransactionService;
import fr.obeo.perseus.server.services.api.transactions.graphql.OpenTransactionInput;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import org.eclipse.sirius.components.annotations.spring.graphql.MutationDataFetcher;
import org.eclipse.sirius.components.core.api.ErrorPayload;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.components.graphql.api.IExceptionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

@MutationDataFetcher(type="Mutation", field="openTransaction")
public class MutationOpenTransactionDataFetcher
implements IDataFetcherWithFieldCoordinates<IPayload> {
    private static final Logger LOG = LoggerFactory.getLogger(MutationOpenTransactionDataFetcher.class);
    private final ObjectMapper objectMapper;
    private final IExceptionWrapper exceptionWrapper;
    private final ITransactionService transactionService;

    public MutationOpenTransactionDataFetcher(ObjectMapper objectMapper, IExceptionWrapper exceptionWrapper, ITransactionService transactionService) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.exceptionWrapper = Objects.requireNonNull(exceptionWrapper);
        this.transactionService = transactionService;
    }

    public IPayload get(DataFetchingEnvironment environment) throws Exception {
        IPayload payload;
        Object argument = environment.getArgument("input");
        OpenTransactionInput input = (OpenTransactionInput)this.objectMapper.convertValue(argument, OpenTransactionInput.class);
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' to open a new transaction submitted", SecurityContextHolder.getContext().getAuthentication().getName(), input.id()));
        }
        if ((payload = this.exceptionWrapper.wrap(() -> this.transactionService.openTransaction(input), (IInput)input)) instanceof ErrorPayload) {
            ErrorPayload errorPayload = (ErrorPayload)payload;
            LOG.warn(String.format("%s - Request '%s' to open a new transaction failed: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), errorPayload));
        } else if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' to open a new transaction successful: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), payload));
        }
        return payload;
    }
}

