/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.controllers.mutation;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.server.common.auth.AuthenticationRequired;
import fr.obeo.perseus.server.model.domain.boundedcontexts.extattachment.services.api.IExtAttachmentRetryService;
import fr.obeo.perseus.server.oauth.api.IAuthenticationRequiredHandler;
import fr.obeo.perseus.server.services.api.attachments.RetryUnsynchronizedAttachmentsInput;
import fr.obeo.perseus.server.services.api.attachments.RetryUnsynchronizedAttachmentsSuccessPayload;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.sirius.components.annotations.spring.graphql.MutationDataFetcher;
import org.eclipse.sirius.components.core.api.ErrorPayload;
import org.eclipse.sirius.components.core.api.IInput;
import org.eclipse.sirius.components.core.api.IPayload;
import org.eclipse.sirius.components.events.ICause;
import org.eclipse.sirius.components.graphql.api.IDataFetcherWithFieldCoordinates;
import org.eclipse.sirius.components.graphql.api.IEditingContextDispatcher;
import org.eclipse.sirius.components.graphql.api.IExceptionWrapper;
import org.eclipse.sirius.web.domain.services.Failure;
import org.eclipse.sirius.web.domain.services.IResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

@MutationDataFetcher(type="Mutation", field="retryUnsynchronizedAttachments")
public class MutationRetryUnsynchronizedAttachmentsDataFetcher
implements IDataFetcherWithFieldCoordinates<IPayload> {
    private static final Logger LOG = LoggerFactory.getLogger(MutationRetryUnsynchronizedAttachmentsDataFetcher.class);
    private final ObjectMapper objectMapper;
    private final IExceptionWrapper exceptionWrapper;
    private final IExtAttachmentRetryService extAttachmentRetryService;
    private final IEditingContextDispatcher editingContextDispatcher;
    private final IAuthenticationRequiredHandler authenticationRequiredHandler;

    public MutationRetryUnsynchronizedAttachmentsDataFetcher(ObjectMapper objectMapper, IExceptionWrapper exceptionWrapper, IExtAttachmentRetryService extAttachmentRetryService, IEditingContextDispatcher editingContextDispatcher, IAuthenticationRequiredHandler authenticationRequiredHandler) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.exceptionWrapper = Objects.requireNonNull(exceptionWrapper);
        this.extAttachmentRetryService = Objects.requireNonNull(extAttachmentRetryService);
        this.editingContextDispatcher = Objects.requireNonNull(editingContextDispatcher);
        this.authenticationRequiredHandler = Objects.requireNonNull(authenticationRequiredHandler);
    }

    public IPayload get(DataFetchingEnvironment environment) throws Exception {
        IPayload payload;
        Object argument = environment.getArgument("input");
        RetryUnsynchronizedAttachmentsInput input = (RetryUnsynchronizedAttachmentsInput)this.objectMapper.convertValue(argument, RetryUnsynchronizedAttachmentsInput.class);
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' in editing context '%s' to retry %d attachments submitted.", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), input.editingContextId(), input.attachmentIds().size()));
        }
        if ((payload = this.exceptionWrapper.wrap(() -> {
            ArrayList<String> errors = new ArrayList<String>();
            try {
                Failure failure;
                IResult result;
                for (UUID attachmentId : input.attachmentIds()) {
                    result = this.extAttachmentRetryService.retryUnsynchronizedAttachment(attachmentId, (ICause)input);
                    if (!(result instanceof Failure)) continue;
                    failure = (Failure)result;
                    errors.add(failure.message());
                }
                for (UUID attachmentArtifactId : input.attachmentArtifactIds()) {
                    result = this.extAttachmentRetryService.retryUnsynchronizedAttachmentArtifact(attachmentArtifactId, (ICause)input);
                    if (!(result instanceof Failure)) continue;
                    failure = (Failure)result;
                    errors.add(failure.message());
                }
                if (!errors.isEmpty()) {
                    return new ErrorPayload(input.id(), String.join((CharSequence)", ", errors));
                }
                this.editingContextDispatcher.dispatchMutation(input.editingContextId(), (IInput)input);
                return new RetryUnsynchronizedAttachmentsSuccessPayload(input.id());
            }
            catch (AuthenticationRequired e) {
                return this.authenticationRequiredHandler.toPayload(e, input.id());
            }
        }, (IInput)input)) instanceof ErrorPayload) {
            ErrorPayload errorPayload = (ErrorPayload)payload;
            LOG.warn(String.format("%s - Request '%s' to retry attachments failed: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), errorPayload));
        } else if (LOG.isInfoEnabled()) {
            LOG.info(String.format("%s - Request '%s' to retry attachments successful: %s", SecurityContextHolder.getContext().getAuthentication().getName(), input.id(), payload));
        }
        return payload;
    }
}

