/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.graphql;

import fr.obeo.perseus.server.common.auth.AuthenticationRequired;
import fr.obeo.perseus.server.common.auth.IAuthenticationRequiredHandlerDelegate;
import fr.obeo.perseus.server.oauth.api.IAuthenticationRequiredHandler;
import graphql.execution.DataFetcherResult;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.sirius.components.core.api.ErrorPayload;
import org.eclipse.sirius.components.core.api.IPayload;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationRequiredHandler
implements IAuthenticationRequiredHandler {
    private final List<IAuthenticationRequiredHandlerDelegate> delegates;

    public AuthenticationRequiredHandler(List<IAuthenticationRequiredHandlerDelegate> delegates) {
        this.delegates = Objects.requireNonNull(delegates);
    }

    public IPayload toPayload(AuthenticationRequired exception, UUID inputId) {
        return this.delegates.stream().filter(delegate -> delegate.test((Object)exception)).findFirst().map(delegate -> delegate.toPayload(exception, inputId)).orElseGet(() -> new ErrorPayload(inputId, exception.getMessage()));
    }

    public <T> DataFetcherResult<T> toErrorDataFetcherResult(AuthenticationRequired exception) {
        return this.delegates.stream().filter(delegate -> delegate.test((Object)exception)).findFirst().map(delegate -> delegate.toErrorDataFetcherResult(exception)).orElseThrow(() -> new IllegalStateException());
    }
}

