/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.server.app.init;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.server.app.init.InitProperties;
import fr.obeo.perseus.server.dto.IMetamodelVisitor;
import fr.obeo.perseus.server.dto.digest.MetamodelDigest;
import fr.obeo.perseus.server.dto.meta.MetaRegistrationDTO;
import fr.obeo.perseus.server.dto.meta.MetamodelDTO;
import fr.obeo.perseus.server.dto.meta.MetamodelInfo;
import fr.obeo.perseus.server.meta.repositories.IMetamodelRepository;
import fr.obeo.perseus.server.meta.services.api.IMetamodelService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.sirius.web.domain.services.Failure;
import org.eclipse.sirius.web.domain.services.IResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class PerseusServerInitBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerseusServerInitBean.class);
    @Autowired
    private IMetamodelRepository mmRepo;
    @Autowired
    private InitProperties initProps;
    @Autowired
    private IMetamodelService mmService;

    @EventListener
    public void onApplicationEvent(ContextRefreshedEvent event) throws IOException {
        ArrayList<String> filesToInsert = new ArrayList<String>();
        for (InitProperties.RequiredMetamodel rm : this.initProps.getMetamodels()) {
            String fileName = rm.getFile().trim();
            MetaRegistrationDTO dto = this.load(fileName);
            MetamodelDigest md = new MetamodelDigest(dto.getMappings().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((MetamodelInfo)e.getValue()).getNsURI())));
            if (dto.getMetamodels().size() != 1) {
                throw new IllegalArgumentException(String.format("Development error - Meta-model file '%s' must contain only one meta-model", fileName));
            }
            MetamodelDTO mmDTO = (MetamodelDTO)dto.getMetamodels().get(0);
            md.init();
            mmDTO.accept((IMetamodelVisitor)md);
            if (mmDTO.getHash() != null && !mmDTO.getHash().equals(md.getHash())) {
                throw new IllegalArgumentException(String.format("Development error - Hash stored in meta-model file '%s' is incorrect, expected '%s'", fileName, md.getHash()));
            }
            if (!this.mmRepo.findByHash(md.getHash()).isEmpty()) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("DB Initialization - Adding file '%s' for registration of meta-model '%s' (hash = '%s')", fileName, rm.getUri(), md.getHash()));
            }
            filesToInsert.add(fileName);
        }
        if (!filesToInsert.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%d meta-models to insert in the database.", filesToInsert.size()));
            }
            for (String fileToInsert : filesToInsert) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("DB Initialization - Storing '%s' in the database.", fileToInsert));
                }
                MetaRegistrationDTO dto = this.load(fileToInsert);
                IResult registerMetamodelResult = this.mmService.register(UUID.randomUUID(), dto);
                if (!(registerMetamodelResult instanceof Failure)) continue;
                Failure f = (Failure)registerMetamodelResult;
                LOGGER.error(f.message());
                throw new IllegalStateException(String.format("Development error - Impossible to store meta-model '%s': %s", fileToInsert, f.message()));
            }
        }
    }

    private MetaRegistrationDTO load(String file) throws IOException {
        return (MetaRegistrationDTO)new ObjectMapper().readerFor(MetaRegistrationDTO.class).readValue(this.getClass().getClassLoader().getResource(file));
    }
}

